package com.dtyunxi.yundt.cube.biz.account.api.constants;

import org.apache.commons.lang3.StringUtils;

/**
 * @Description: 账户流水变更类型
 * @Author: 水镜
 * @Date: 2019/7/5 16:23
 * @Version: 0.1.0
 */
public enum AccountFlowTypeEnum {

    CHARGE("01", "充值", "充值"),
    PAY("02", "支付", "支付"),
    CHARGE_REVERSE("03", "充值冲正", "充值冲正"),
    PAY_REVERSE("04", "支付冲正", "支付冲正"),
    REFUND("05", "退款", "支付退款"),
    PRESENT("06", "充值赠送", "分期赠送"),
    CZ_ADD("07", "充值调账增加", "充值增加储值"),
    CZ_DEL("08", "充值调账减少", "充值扣减储值"),
    PAY_ADD("09", "消费调账增加", "消费返回储值"),
    PAY_DEL("10", "消费调账减少", "消费扣减储值"),
    MERGE_ADD("11", "会员合并增加", "合并账户增加储值"),
    MERGE_DEL("12", "会员合并减少", "合并账户减少储值"),
    CHARGE_REFUND("13", "充值退款", "充值退款"),
    DISTRIBUTION_ADD("14", "分销佣金到账", "分销佣金到账"),
    DISTRIBUTION_WITHDRAW("15", "分销佣金提现", "分销佣金提现");


    private final String code;
    private final String description;
    //类型名称，提供给储值列表和储值列表导出使用
    private final String name;

    AccountFlowTypeEnum(String code, String description, String name) {
        this.code = code;
        this.description = description;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public String getName() {
        return name;
    }

    public static AccountFlowTypeEnum findEnum(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for (AccountFlowTypeEnum accountFlowTypeEnum: values()){
            if(accountFlowTypeEnum.getCode().equals(code)){
                return accountFlowTypeEnum;
            }
        }
        return null;
    }
    public static String getChangeTypeCode(String code){
        for (AccountFlowTypeEnum accountChangeTypeEnum: AccountFlowTypeEnum.values()) {
            if (accountChangeTypeEnum.getCode().equals(code)){
                return accountChangeTypeEnum.getDescription();
            }
        }
        return null;
    }

    public static String getNameByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for (AccountFlowTypeEnum accountChangeTypeEnum: AccountFlowTypeEnum.values()) {
            if (accountChangeTypeEnum.getCode().equals(code)){
                return accountChangeTypeEnum.getName();
            }
        }
        return null;
    }
}
