/*
 * *
 *  @(#)Constants.java 1.0 19-6-20 下午2:25
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * /
 */

package com.dtyunxi.yundt.cube.biz.account.api.constants;

import com.dtyunxi.util.DateUtil;

import java.util.Date;

public class Constants {
    /**
     * 初始化等级成长值为0
     */
    public static final Integer INIT_MIN_GROWTH_VALUE =  0;

    /***
     * 批量修改会员等级数量
     */
    public static final Integer MAX_MODIFY_LEVEL_NUM =  100;

    /***
     * 会员编号在Redis的key名称
     */
    public static final String MEMBER_INFO_MEMBER_NO =  "member_info_member_no";

    /**
     * 会员预警：pos订单数据
     */
    public static final String MEMBER_WARN_POS_ORDER =  "member_warn_pos_order";
    /***
     * 短信有效期（秒）
     */
    public static final int PERIOD_OF_VALIDITY = 60;

    /***
     * 验证码位数
     */
    public static final int VALIDITY_CODE_LENGTH = 6;

    /***
     * 短信挂失验证码（基础数据code）
     */
    public static final String MEMBER_LOSE_VALIDITY_CODE = "memberValidityCode";
    /***
     * 短信解挂验证码（基础数据code）
     */
    public static final String MEMBER_UN_LOSE_VALIDITY_CODE = "memberValidityCode";

    /***
     * 初始等级的会员等级到期日
     */
    public static final Date DEFAULT_EXPIRE_TIME = DateUtil.parse("9999-12-31");

    /***
     * 等级计算时间配置（基础数据code）
     */
    public static final String SCHEDULER_CODE = "calculateLevelTask";


    /**
     * 会员规则集状态
     */
    public final static int RULESET_STATUS_NORMAL = 1;// 启用状态
    public final static int RULESET_STATUS_DISABLE = 0;// 禁用状态

    /***
     * 会员等级定时任务每页执行大小
     */
    public final static int SCHEDULE_PAGE_SIZE = 10;

    /***
     * 会员映射编码基础数据groupcode
     */

    public final static String MEMBER_GROUP_CODE="memberInfoMapperCode";

    /**
     * 订单预警
     */
    public final static int POS_ORDER_WARN = 1;

    /**
     * 储值预警
     */
    public final static int STORED_CARD_WARN = 2;

    /**
     * 批量创建储值账户MQ
     */
    public final static String MEMBER_STORED_ACCOUNT_BATCH_CREATE_TAG = "member_stored_account_batch_create_tag";

    /**
     * 账户中心批量创建储值账户MQ——topic
     */
    public final static String  MEMBER_STORED_ACCOUNT_BATCH_CREATE_TOPIC = "member_stored_account_batch_create_topic";

    /**
     * 事件池触发前开始topic --- TOPIC
     */
    public final static String IMK_EVENT_TRIGGER_TOPIC = "IMK_EVENT_TRIGGER_TOPIC";
    /**
     * 事件池触发前开始tag --- TAG
     */
    public final static String IMK_EVENT_TRIGGER_TAG = "IMK_EVENT_TRIGGER_TAG";

    /**
     * 支付成功
     */
    public static final String PAY_NOTIFY_STATUS_SUCC = "S";

    /**
     * 支付通知路径
     */
    public static final String PAY_NOTIFY_PATH = "recharge/";
}
