package com.dtyunxi.yundt.cube.biz.account.api.constants;

/**
 * 附件单据类型
 *
 * @author sumo
 * @date 2020/12/17 0017
 */
public enum ExportTypeEnum {

    /**
     * 账号流水-ACCOUNT_FLOW;充值记录-RECHARGE_RECORD;充值单-RECHARGE_ORDER
     * ;账号列表- ACCOUNT_RECORD
     */
    ACCOUNT_FLOW("ACCOUNT_FLOW", "账号流水"),
    RECHARGE_RECORD("RECHARGE_RECORD", "充值记录"),
    RECHARGE_ORDER("RECHARGE_ORDER", "充值单"),
    ACCOUNT_RECORD("ACCOUNT_RECORD", "账号列表"),
    ;

    private String code;
    private String name;

    ExportTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static ExportTypeEnum fromCode(String code) {
        for (ExportTypeEnum typeEnum : ExportTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        ExportTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        ExportTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public String toName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
