package com.dtyunxi.yundt.cube.biz.account.api.constants;

/**
 * <p> 通用规则编码类型 </p>
 *
 * @author : 靖儿
 * @since : 1.0.0
 */
public enum GeneralRuleCodeType {
    /**
     * 通用规则编码类型:枚举序号、编码前缀、描述、数据长度
     * 系统自动替换{date}为DateUtil.format(new Date(), "yyyyMMdd") 如果有其他需求变动,就重构吧,
     */
    YECZ(1, "YECZ{date}", "充值订单", 5, "AccountRechargeOrderEo", "order_no"),
    YEMX(1, "YEMX{date}", "余额明细", 5, "AccountFlowEo", "code"),
    YEZH(1, "YEZH{date}", "余额账号", 5, "AccountEo", "member_no"),
    ;


    private Integer type;
    private String code;
    private String desc;
    private Integer num;

    /**
     * 对应的EO对象名称;
     */
    private String clazz;
    /**
     * Eo实体中编码字段,默认命名为code,不排除其他命名,支持配置；
     */
    private String field;

    GeneralRuleCodeType(Integer type, String code, String desc, Integer num, String clazz, String field) {
        this.type = type;
        this.code = code;
        this.desc = desc;
        this.num = num;
        this.clazz = clazz;
        this.field = field;
    }

    public static GeneralRuleCodeType getType(Integer type) {
        for (GeneralRuleCodeType value : GeneralRuleCodeType.values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }

    public static GeneralRuleCodeType getDesc(String desc) {
        for (GeneralRuleCodeType value : GeneralRuleCodeType.values()) {
            if (value.getDesc().equals(desc)) {
                return value;
            }
        }
        return null;
    }


    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public String getClazz() {
        return clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }}

