package com.dtyunxi.yundt.cube.biz.account.api.constants;

/**
 * 附件单据类型
 *
 * @author sumo
 * @date 2020/12/17 0017
 */
public enum RelateTypeEnum {

    /**
     * 附件单据类型
     */
    RECHARGE_APPLY(1, "充值申请单"),

    ;

    private Integer code;
    private String name;

    RelateTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static RelateTypeEnum fromCode(Integer code) {
        for (RelateTypeEnum typeEnum : RelateTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static Integer toCode(Integer status) {
        RelateTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(Integer status) {
        RelateTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public String toName() {
        return name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
