package com.dtyunxi.yundt.cube.biz.account.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 会员卡账户查询dto
 * @Author: 水镜
 * @Date: 2019/8/16 19:51
 * @Version: 0.1.0
 */
@ApiModel(value = "AccountQueryReqDto", description = "会员卡账户查询dto")
public class AccountQueryReqDto {

    @ApiModelProperty(name = "accountType", value = "会员账户类型")
    private String accountType;

    /**
     * 手机号
     */
    @ApiModelProperty(name = "mobile", value = "手机号")
    private String mobile;
    /**
     * 会员卡号
     */
    @ApiModelProperty(name = "cardNo", value = "会员卡号")
    private String cardNo;
    /**
     * 会员编号
     */
    @ApiModelProperty(name = "memberNo", value = "会员编号")
    private String memberNo;
    /**
     * 客户编号
     */
    @ApiModelProperty(name = "customerNo", value = "客户编号")
    private String customerNo;
    /**
     * 会员姓名
     */
    @ApiModelProperty(name = "memberName", value = "会员姓名")
    private String memberName;
    /**
     * 账户状态（C=激活、X=冻结、E=挂失、D=注销）
     */
    @ApiModelProperty(name = "status", value = "账户状态（C=激活、X=冻结、E=挂失、D=注销）")
    private String status;
    /**
     * 最小余额
     */
    @ApiModelProperty(name = "minBalance", value = "最小余额")
    private String minBalance;
    /**
     * 最大余额
     */
    @ApiModelProperty(name = "maxBalance", value = "最大余额")
    private String maxBalance;
    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startTime", value = "开始时间")
    private String startTime;
    /**
     * 结束时间
     */
    @ApiModelProperty(name = "endTime", value = "结束时间")
    private String endTime;
    /**
     * 每页数
     */
    @ApiModelProperty(name = "pageSize", value = "每页数")
    private Integer pageSize;
    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMinBalance() {
        return minBalance;
    }

    public void setMinBalance(String minBalance) {
        this.minBalance = minBalance;
    }

    public String getMaxBalance() {
        return maxBalance;
    }

    public void setMaxBalance(String maxBalance) {
        this.maxBalance = maxBalance;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
}
