package com.dtyunxi.yundt.cube.biz.account.api.dto.request;

import com.dtyunxi.cube.biz.commons.annotation.SqlFilterProperty;
import com.dtyunxi.cube.biz.commons.enums.SqlOperator;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @Description:
 * @Author: 小骨
 * @Date: 2019/7/02 14:18
 * @Version: 0.1.0
 */
@ApiModel(value = "cardFinanceRecordQueryReqDto", description = "会员卡账户流水查询接口")
public class CardFinanceRecordQueryReqDto extends RequestDto {

    @ApiModelProperty(name = "cardAccountId", value = "会员卡账号id")
    @SqlFilterProperty(operator = SqlOperator.eq, column="accountId")
    private Long cardAccountId;

    @ApiModelProperty(name = "cardAccountIdList", value = "会员卡账号idList")
    @SqlFilterProperty(operator = SqlOperator.in, column="accountId")
    private List<Long> cardAccountIdList;

    @ApiModelProperty(name = "type", value = "类型：01充值,02 支付03,充值冲正；04支付冲正；05退款;")
    @SqlFilterProperty(operator  =  SqlOperator.in, column="changeType")
    private String type;
    @ApiModelProperty(name = "isReverse", value = "是否冲正")
    @SqlFilterProperty(operator  =  SqlOperator.eq, column="isReverse")
    private String isReverse;

    @ApiModelProperty(name = "tradeId", value = "交易流水")
    @SqlFilterProperty(operator  =  SqlOperator.eq, column="trade_id")
    private String tradeId;

    @ApiModelProperty(name = "createTime", value = "充值时间")
    @SqlFilterProperty(operator  =  SqlOperator.eq, column="createTime")
    private String createTime;

    @ApiModelProperty(name ="createTimeBeginTime" ,value ="创建时间开始区间")
    @SqlFilterProperty(operator = SqlOperator.ge, column = "createTime")
    private Date createTimeBeginTime;

    @ApiModelProperty(name ="createTimeEndTime" ,value ="创建时间结束区间")
    @SqlFilterProperty(operator = SqlOperator.le, column = "createTime")
    private Date createTimeEndTime;

    @ApiModelProperty(name ="changeTypeList" ,value ="变更类型（01=充值、02=支付、03=充值冲正、04=支付冲正、05=退款/06=赠送积分）")
    @SqlFilterProperty(operator = SqlOperator.in, column = "changeType")
    private List<String> changeTypeList;

    @ApiModelProperty(name = "activeCode", value = "活动编号")
    @SqlFilterProperty(operator  =  SqlOperator.eq, column="activeCode")
    private String activeCode;

    @ApiModelProperty(name = "storeCode", value = "店铺编号")
    @SqlFilterProperty(operator  =  SqlOperator.eq, column="storeCode")
    private String storeCode;

    @ApiModelProperty(name = "memberNo", value = "会员编号")
    @SqlFilterProperty(operator  =  SqlOperator.eq, column="memberNo")
    private String memberNo;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    @ApiModelProperty(name = "cardNo", value = "会员卡号")
    private String cardNo;

    @ApiModelProperty(name = "phone", value = "手机号")
    private String phone;

    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;

    @ApiModelProperty(name = "customerNo", value = "客户编号")
    private String customerNo;

    @ApiModelProperty(name = "code", value = "单据号")
    private String code;

    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    public Long getCardAccountId() {
        return cardAccountId;
    }

    public void setCardAccountId(Long cardAccountId) {
        this.cardAccountId = cardAccountId;
    }

    public List<Long> getCardAccountIdList() {
        return cardAccountIdList;
    }

    public void setCardAccountIdList(List<Long> cardAccountIdList) {
        this.cardAccountIdList = cardAccountIdList;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public String getIsReverse() {
        return isReverse;
    }

    public void setIsReverse(String isReverse) {
        this.isReverse = isReverse;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getActiveCode() {
        return activeCode;
    }

    public void setActiveCode(String activeCode) {
        this.activeCode = activeCode;
    }

    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Date getCreateTimeBeginTime() {
        return createTimeBeginTime;
    }

    public void setCreateTimeBeginTime(Date createTimeBeginTime) {
        this.createTimeBeginTime = createTimeBeginTime;
    }

    public Date getCreateTimeEndTime() {
        return createTimeEndTime;
    }

    public void setCreateTimeEndTime(Date createTimeEndTime) {
        this.createTimeEndTime = createTimeEndTime;
    }

    public List<String> getChangeTypeList() {
        return changeTypeList;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public void setChangeTypeList(List<String> changeTypeList) {
        this.changeTypeList = changeTypeList;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
