/**
 * @(#)DisableMemberAllReqDto 1.0 2019/7/11
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.biz.account.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 会员卡解冻请求DTO
 *@author 传君
 * Created by jiyq on 2019/7/11.
 */
@ApiModel(value = "DisableMemberAllReqDto", description = "会员卡解冻请求DTO")
public class DisableMemberAllReqDto extends RequestDto {

    @ApiModelProperty(name = "memberId", value = "会员Id")
    @NotNull(message = "会员Id不能为空")
    private Long memberId;

    @ApiModelProperty(name = "type", value = "0主动冻结；1自动冻结；2挂失")
    @NotNull(message = "操作类型不能为空")
    private Integer type;

    @ApiModelProperty(name = "status", value = "0挂失/冻结 1解挂/解冻")
    @NotNull(message = "操作类型不能为空")
    private Integer status;

    @ApiModelProperty(name = "disableMemberReqDto", value = "冻结挂失请求Dto")
    private DisableMemberReqDto disableMemberReqDto;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public DisableMemberReqDto getDisableMemberReqDto() {
        return disableMemberReqDto;
    }

    public void setDisableMemberReqDto(DisableMemberReqDto disableMemberReqDto) {
        this.disableMemberReqDto = disableMemberReqDto;
    }
}
