package com.dtyunxi.yundt.cube.biz.account.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @Description: 会员卡账户Dto
 * @Author: 小骨
 * @Date: 2019/6/28 15:04
 * @Version: 0.1.0
 */
@ApiModel(value = "memberCardAccountUpdateReqDto", description = "会员卡账户Dto")
public class MemberCardAccountUpdateReqDto extends RequestDto {

    @ApiModelProperty(name = "memberId", value = "会员Id")
    private Long memberId;

    @ApiModelProperty(name = "tradeId", value = "交易流水")
    private String tradeId;

    @ApiModelProperty(name = "type", value = "交易类型")
    private String type;

    @ApiModelProperty(name = "principal", value = "本金")
    private BigDecimal principal;

    @ApiModelProperty(name ="giveAmount" ,value ="赠送金额(冻结)" )
    private BigDecimal giveAmount;

    @ApiModelProperty(name ="givePoint" ,value ="赠送积分" )
    private String givePoint;

    @ApiModelProperty(name ="giveCoupon" ,value ="赠送券" )
    private String giveCoupon;

    @ApiModelProperty(name ="storeCode" ,value ="店铺编码" )
    private String storeCode;

    @ApiModelProperty(name ="prcuser" ,value ="操作人工号" )
    private String prcuser;

    @ApiModelProperty(name ="deviceNo" ,value ="设备号" )
    private String deviceNo;

    @ApiModelProperty(name ="activeCode" ,value ="活动编号" )
    private String activeCode;

    @ApiModelProperty(name ="memberNo" ,value ="会员编号" )
    private String memberNo;

    @ApiModelProperty(name ="customerNo" ,value ="客户编号" )
    private String customerNo;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BigDecimal getPrincipal() {
        return principal;
    }

    public void setPrincipal(BigDecimal principal) {
        this.principal = principal;
    }

    public BigDecimal getGiveAmount() {
        return giveAmount;
    }

    public void setGiveAmount(BigDecimal giveAmount) {
        this.giveAmount = giveAmount;
    }

    public String getGivePoint() {
        return givePoint;
    }

    public void setGivePoint(String givePoint) {
        this.givePoint = givePoint;
    }

    public String getGiveCoupon() {
        return giveCoupon;
    }

    public void setGiveCoupon(String giveCoupon) {
        this.giveCoupon = giveCoupon;
    }

    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getPrcuser() {
        return prcuser;
    }

    public void setPrcuser(String prcuser) {
        this.prcuser = prcuser;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public String getActiveCode() {
        return activeCode;
    }

    public void setActiveCode(String activeCode) {
        this.activeCode = activeCode;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }
}
