package com.dtyunxi.yundt.cube.biz.account.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @Description: 会员卡生成Dto
 * @Author: 小骨
 * @Date: 2019/6/28 15:04
 * @Version: 0.1.0
 */
@ApiModel(value = "memberCardAddReqDto", description = "会员卡生成Dto")
public class MemberCardAddReqDto extends RequestDto {

    @ApiModelProperty(name = "memberId", value = "会员Id")
    @NotNull(message = "会员Id不能为空")
    private Long memberId;

    @ApiModelProperty(name = "memberCode", value = "会员编号")
    @NotNull(message = "会员编号不能为空")
    private String memberCode;

    @ApiModelProperty(name = "memberName", value = "会员名称")
    private String memberName;

    @ApiModelProperty(name = "storeCode", value = "店铺编号")
    private String storeCode;

    @ApiModelProperty(name = "customerNo", value = "客户编号")
    @NotNull(message = "客户编号不能为空")
    private String customerNo;

    @ApiModelProperty(name = "memberModelId", value = "会员体系ID")
    private Long memberModelId;

    @ApiModelProperty(name = "phone", value = "手机号")
    @NotNull(message = "手机号不能为空")
    private String phone;

    @ApiModelProperty(name = "cardNo", value = "会员卡号（实体卡绑定用到）")
    private String cardNo;

    @ApiModelProperty(name = "physicalCard", value = "0 虚拟卡;1实体卡")
    //@NotNull(message = "生成卡类型不能为空")
    private Integer physicalCard;

    @ApiModelProperty(name = "activeType", value = "卡激活方式  门店/APP/微信/支付宝/口碑/有赞/美团/京东/天猫/淘宝")
    //@NotNull(message = "卡激活方式")
    private String activeType;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getPhysicalCard() {
        return physicalCard;
    }

    public void setPhysicalCard(Integer physicalCard) {
        this.physicalCard = physicalCard;
    }

    public String getActiveType() {
        return activeType;
    }

    public void setActiveType(String activeType) {
        this.activeType = activeType;
    }

    public Long getMemberModelId() {
        return memberModelId;
    }

    public void setMemberModelId(Long memberModelId) {
        this.memberModelId = memberModelId;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }
}
