package com.dtyunxi.yundt.cube.biz.account.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @Description: 会员卡线上退款Dto（监听OMS销退单/取消单）
 * @Author: 水镜
 * @Date: 2019/8/27 16:33
 * @Version: 0.1.0
 */
@ApiModel(value = "MemberCardAppRefundReqDto", description = "会员卡退款Dto（用于线上退款，监听OMS销退单/取消单）")
public class MemberCardAppRefundReqDto {

    /**
     * 会员id
     */
    @ApiModelProperty(name = "memberId", value = "会员id")
    private Long memberId;
    /**
     * 店铺编号
     */
    @ApiModelProperty(name = "storeNo", value = "店铺编号")
    private String storeNo;
    /**
     * 原订单号
     */
    @ApiModelProperty(name = "orderNo", value = "原订单号")
    private String orderNo;
    /**
     * 退款金额
     */
    @ApiModelProperty(name = "refundAmount", value = "退款金额")
    private BigDecimal refundAmount;
    /**
     *  折扣率
     *
     */
    @ApiModelProperty(name = "discountRage", value = "折扣率")
    private BigDecimal discountRage;
    /**
     * 退款本金
     */
    @ApiModelProperty(name = "refundPrincipalAmount", value = "退款本金")
    private BigDecimal refundPrincipalAmount;
    /**
     * 退款赠额
     */
    @ApiModelProperty(name = "refundPresentAmount", value = "退款赠额")
    private BigDecimal refundPresentAmount;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getStoreNo() {
        return storeNo;
    }

    public void setStoreNo(String storeNo) {
        this.storeNo = storeNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public BigDecimal getDiscountRage() {
        return discountRage;
    }

    public void setDiscountRage(BigDecimal discountRage) {
        this.discountRage = discountRage;
    }

    public BigDecimal getRefundPrincipalAmount() {
        return refundPrincipalAmount;
    }

    public void setRefundPrincipalAmount(BigDecimal refundPrincipalAmount) {
        this.refundPrincipalAmount = refundPrincipalAmount;
    }

    public BigDecimal getRefundPresentAmount() {
        return refundPresentAmount;
    }

    public void setRefundPresentAmount(BigDecimal refundPresentAmount) {
        this.refundPresentAmount = refundPresentAmount;
    }
}
