package com.dtyunxi.yundt.cube.biz.account.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Description: 会员卡支付Dto
 * @Author: 水镜
 * @Date: 2019/7/5 15:47
 * @Version: 0.1.0
 */
@ApiModel(value = "MemberCardPayReqDto", description = "会员卡支付Dto")
public class MemberCardPayReqDto {

    /**
     * 会员id
     */
    @ApiModelProperty(name = "memberId", value = "会员id")
    @NotNull
    private Long memberId;
    /**
     * 店铺编号
     */
    @ApiModelProperty(name = "storeNo", value = "店铺编号")
    @NotNull
    private String storeNo;
    /**
     * 订单编号
     */
    @ApiModelProperty(name = "orderNo", value = "订单编号")
    @NotNull
    private String orderNo;
    /**
     * 交易流水号
     */
    @ApiModelProperty(name = "tradeId", value = "交易流水号")
    @NotNull
    private String tradeId;
    /**
     * 支付总额
     */
    @ApiModelProperty(name = "payAmount", value = "支付总额")
    @NotNull
    private BigDecimal payAmount;
    /**
     * 交易类型
     */
    @ApiModelProperty(name = "type", value = "交易类型")
    private String type;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getStoreNo() {
        return storeNo;
    }

    public void setStoreNo(String storeNo) {
        this.storeNo = storeNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
