package com.dtyunxi.yundt.cube.biz.account.api.dto.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 充值退款dto
 */
@ApiModel(value = "MemberCardRechargeRefundReqDto", description = "充值退款dto")
public class MemberCardRechargeRefundReqDto extends RequestDto {

    @ApiModelProperty(name = "storeNo", value = "门店编号")
    private String storeNo;

    @ApiModelProperty(name = "memberNo", value = "会员编号")
    private String memberNo;

    @ApiModelProperty(name = "memberId", value = "会员id")
    private Long memberId;

    @ApiModelProperty(name = "orderNo", value = "订单编号")
    private String orderNo;

    @ApiModelProperty(name = "payNo", value = "支付编号")
    private String payNo;

    @ApiModelProperty(name = "refundNo", value = "退款编号")
    private String refundNo;

    @ApiModelProperty(name = "refundAmount", value = "退款金额")
    private BigDecimal refundAmount;

    @ApiModelProperty(name = "isWhole", value = "是否全额退款")
    private Boolean isWhole;

    public String getStoreNo() {
        return storeNo;
    }

    public void setStoreNo(String storeNo) {
        this.storeNo = storeNo;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getPayNo() {
        return payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public String getRefundNo() {
        return refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public Boolean getWhole() {
        return isWhole;
    }

    public void setWhole(Boolean whole) {
        isWhole = whole;
    }

    public static void main(String[] args) {
        System.out.println(JSON.toJSONString(new MemberCardRechargeRefundReqDto(), SerializerFeature.WriteMapNullValue));
    }
}
