package com.dtyunxi.yundt.cube.biz.account.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Description: 会员卡线下退款Dto（用于POS退款）
 * @Author: 水镜
 * @Date: 2019/7/18 16:33
 * @Version: 0.1.0
 */
@ApiModel(value = "MemberCardRefundReqDto", description = "会员卡退款Dto（用于线下退款）")
public class MemberCardRefundReqDto {

    /**
     * 会员id
     */
    @ApiModelProperty(name = "memberId", value = "会员id")
    @NotNull
    private Long memberId;
    /**
     * 店铺编号
     */
    @ApiModelProperty(name = "storeNo", value = "店铺编号")
    @NotNull
    private String storeNo;
    /**
     * 原订单号
     */
    @ApiModelProperty(name = "orderNo", value = "原订单号")
    @NotNull
    private String orderNo;
    /**
     * 退单号
     */
    @ApiModelProperty(name = "returnOrderNo", value = "退单号")
    @NotNull
    private String returnOrderNo;
    /**
     * 退款金额
     */
    @ApiModelProperty(name = "refundAmount", value = "退款金额")
    @NotNull
    private BigDecimal refundAmount;
    /**
     * 收银机号
     */
    @ApiModelProperty(name = "deviceNo", value = "收银机号")
    @NotNull
    private String deviceNo;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getStoreNo() {
        return storeNo;
    }

    public void setStoreNo(String storeNo) {
        this.storeNo = storeNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getReturnOrderNo() {
        return returnOrderNo;
    }

    public void setReturnOrderNo(String returnOrderNo) {
        this.returnOrderNo = returnOrderNo;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }
}
