package com.dtyunxi.yundt.cube.biz.account.api.dto.response;

import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "accountQueryRespDto", description = "会员卡账户Dto")
public class AccountQueryRespDto extends BaseRespDto {
    /**
     *  NORMAL 普通账户 FEE手续费 SUPPER主账号 WARRANT 担保 CREDIT 信用 CREDIT_SUPPER信用主帐号
     */
    @ApiModelProperty(name = "accountType", value = "普通账户")
    private String accountType;
    /**
     *  会员编号
     */
    @ApiModelProperty(name = "memberNo", value = "会员编号")
    private String memberNo;
    /**
     *  客户编号
     */
    @ApiModelProperty(name = "customerNo", value = "客户编号")
    private String customerNo;

    /**
     *  外部ID,可以对应会员ID
     *
     */
    @ApiModelProperty(name = "outerId", value = "外部ID")
    private String outerId;
    /**
     *  PERSONAL会员用户 ENTERPRISE企业用户
     *
     */
    @ApiModelProperty(name = "userType", value = "PERSONAL会员用户")
    private String userType;
    /**
     *  账户名
     *
     */
    @ApiModelProperty(name = "nickName", value = "账户名")
    private String nickName;
    /**
     *  手机号
     *
     */
    @ApiModelProperty(name = "mobile", value = "手机号")
    private String mobile;
    /**
     *  邮箱
     *
     */
    @ApiModelProperty(name = "email", value = "邮箱")
    private String email;
    /**
     *  证件类型
     *
     */
    @ApiModelProperty(name = "idType", value = "证件类型")
    private String idType;
    /**
     *  证件号码
     *
     */
    @ApiModelProperty(name = "idCode", value = "证件号码")
    private String idCode;
    /**
     *  状态（C=激活、X=冻结、E=挂失、D=注销）
     *
     */
    @ApiModelProperty(name = "status", value = "状态")
    private String status;
    /**
     *
     *总余额
     */
    @ApiModelProperty(name = "balance", value = "总余额")
    private BigDecimal balance;
    /**
     *  已冻结余额
     *
     */
    @ApiModelProperty(name = "frozen", value = "已冻结余额")
    private BigDecimal frozen;
    /**
     *  可提现余额
     *
     */
    @ApiModelProperty(name = "disposable", value = "可提现余额")
    private BigDecimal disposable;
    /**
     *  账户密码
     *
     */
    @ApiModelProperty(name = "password", value = "账户密码")
    private String password;
    /**
     *  本金余额
     *
     */
    @ApiModelProperty(name = "principalBalance", value = "本金余额")
    private BigDecimal principalBalance;
    /**
     *  赠送余额
     *
     */
    @ApiModelProperty(name = "presentBalance", value = "赠送余额")
    private BigDecimal presentBalance;
    /**
     *  待赠送余额
     *
     */
    @ApiModelProperty(name = "waitingPresentBalance", value = "待赠送余额")
    private BigDecimal waitingPresentBalance;
    /**
     *  折扣率
     *
     */
    @ApiModelProperty(name = "discountRage", value = "折扣率")
    private BigDecimal discountRage;
    /**
     *  总消费余额
     *
     */
    @ApiModelProperty(name = "totalConsumeAmount", value = "总消费余额")
    private BigDecimal totalConsumeAmount;
    /**
     *  最后消费时间
     *
     */
    @ApiModelProperty(name = "lastConsumeTime", value = "最后消费时间")
    private Date lastConsumeTime;

    @ApiModelProperty(name = "createTime",value="创建时间")
    private Date createTime;

    @ApiModelProperty(name = "updateTime",value="更新时间")
    private Date updateTime;

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }


    public String getOuterId() {
        return outerId;
    }

    public void setOuterId(String outerId) {
        this.outerId = outerId;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getIdCode() {
        return idCode;
    }

    public void setIdCode(String idCode) {
        this.idCode = idCode;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getFrozen() {
        return frozen;
    }

    public void setFrozen(BigDecimal frozen) {
        this.frozen = frozen;
    }

    public BigDecimal getDisposable() {
        return disposable;
    }

    public void setDisposable(BigDecimal disposable) {
        this.disposable = disposable;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public BigDecimal getPrincipalBalance() {
        return principalBalance;
    }

    public void setPrincipalBalance(BigDecimal principalBalance) {
        this.principalBalance = principalBalance;
    }

    public BigDecimal getPresentBalance() {
        return presentBalance;
    }

    public void setPresentBalance(BigDecimal presentBalance) {
        this.presentBalance = presentBalance;
    }

    public BigDecimal getWaitingPresentBalance() {
        return waitingPresentBalance;
    }

    public void setWaitingPresentBalance(BigDecimal waitingPresentBalance) {
        this.waitingPresentBalance = waitingPresentBalance;
    }

    public BigDecimal getDiscountRage() {
        return discountRage;
    }

    public void setDiscountRage(BigDecimal discountRage) {
        this.discountRage = discountRage;
    }

    public BigDecimal getTotalConsumeAmount() {
        return totalConsumeAmount;
    }

    public void setTotalConsumeAmount(BigDecimal totalConsumeAmount) {
        this.totalConsumeAmount = totalConsumeAmount;
    }

    public Date getLastConsumeTime() {
        return lastConsumeTime;
    }

    public void setLastConsumeTime(Date lastConsumeTime) {
        this.lastConsumeTime = lastConsumeTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
