package com.dtyunxi.yundt.cube.biz.account.api.dto.response;


import com.dtyunxi.cube.biz.commons.annotation.SqlFilterProperty;
import com.dtyunxi.cube.biz.commons.enums.SqlOperator;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Description: 会员卡账户流水
 * @Author: 小骨
 * @Date 2019/07/04
 * @Version: 0.1.0
 */
@ApiModel(value = "cardFinanceRecordRespDto", description = "会员卡账户流水Dto")
public class CardFinanceRecordRespDto extends BaseRespDto {

    @ApiModelProperty(name = "num", value = "序号")
    private int num;

    @ApiModelProperty(name = "cardAccountId", value = "会员账户Id")
    private Long cardAccountId;

    @ApiModelProperty(name = "memberId", value = "会员Id")
    private Long memberId;

    @ApiModelProperty(name = "accountId", value = "会员Id")
    private Long accountId;

    @ApiModelProperty(name = "memberNo", value = "会员编号")
    private String memberNo;

    @ApiModelProperty(name = "customerNo", value = "会员编号")
    private String customerNo;

    @ApiModelProperty(name = "tradeId", value = "交易流水")
    private String tradeId;

    @ApiModelProperty(name = "code", value = "单据号")
    private String code;

    @ApiModelProperty(name = "activeCode", value = "活动编号")
    private String activeCode;

    @ApiModelProperty(name = "type", value = "交易类型")
    private Integer type;

    @ApiModelProperty(name = "tradePrincipalAmount", value = "交易本金")
    private BigDecimal tradePrincipalAmount;

    @ApiModelProperty(name = "tradePresentAmount", value = "交易赠额")
    private BigDecimal tradePresentAmount;

    @ApiModelProperty(name ="tradeAmount" ,value ="交易金额" )
    private BigDecimal tradeAmount;

    @ApiModelProperty(name ="giveAmount" ,value ="赠送金额" )
    private BigDecimal giveAmount;

    @ApiModelProperty(name ="givePoint" ,value ="赠送积分" )
    private String givePoint;

    @ApiModelProperty(name ="giveCoupon" ,value ="赠送券" )
    private String giveCoupon;

    @ApiModelProperty(name ="storeCode" ,value ="店铺编码" )
    private String storeCode;

    @ApiModelProperty(name ="storeName" ,value ="店铺名称" )
    private String storeName;

    @ApiModelProperty(name ="channelCode" ,value ="渠道编号" )
    private String channelCode;

    @ApiModelProperty(name ="deviceNo" ,value ="设备号" )
    private String deviceNo;

    @ApiModelProperty(name ="cardNo" ,value ="卡号" )
    private String cardNo;

    @ApiModelProperty(name ="mobileNo" ,value ="手机号" )
    private String mobileNo;

    @ApiModelProperty(name ="isReverse" ,value ="是否冲正（0=否 1=是）" )
    private Integer isReverse;

    @ApiModelProperty(name ="changeType" ,value ="变更类型（01=充值、02=支付、03=充值冲正、04=支付冲正、05=退款/06=赠送积分）")
    private String changeType;

    @ApiModelProperty(name ="createTime" ,value ="创建时间" )
    private Date createTime;

    @ApiModelProperty(name ="createTimeBeginTime" ,value ="创建时间开始区间")
    @SqlFilterProperty(operator = SqlOperator.ge, column = "createTime")
    private Date createTimeBeginTime;

    @ApiModelProperty(name ="createTimeEndTime" ,value ="创建时间结束区间")
    @SqlFilterProperty(operator = SqlOperator.le, column = "createTime")
    private Date createTimeEndTime;

    @ApiModelProperty(name ="changeTypeList" ,value ="变更类型（01=充值、02=支付、03=充值冲正、04=支付冲正、05=退款/06=赠送积分）")
    @SqlFilterProperty(operator = SqlOperator.in, column = "changeType")
    private List<String> changeTypeList;

    @ApiModelProperty(
            name = "orderByDesc",
            value = "降序字段,多个字段时逗号隔开"
    )
    private String orderByDesc;

    @ApiModelProperty(name ="PresentRecodeFlowDto" ,value ="赠送流水dto" )
    private PresentRecodeFlowDto presentRecodeFlowDto;

    public BigDecimal getTradeAmount() {
        return tradeAmount;
    }

    public void setTradeAmount(BigDecimal tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getTradePrincipalAmount() {
        return tradePrincipalAmount;
    }

    public void setTradePrincipalAmount(BigDecimal tradePrincipalAmount) {
        this.tradePrincipalAmount = tradePrincipalAmount;
    }

    public BigDecimal getTradePresentAmount() {
        return tradePresentAmount;
    }

    public void setTradePresentAmount(BigDecimal tradePresentAmount) {
        this.tradePresentAmount = tradePresentAmount;
    }

    public String getGivePoint() {
        return givePoint;
    }

    public void setGivePoint(String givePoint) {
        this.givePoint = givePoint;
    }

    public String getGiveCoupon() {
        return giveCoupon;
    }

    public void setGiveCoupon(String giveCoupon) {
        this.giveCoupon = giveCoupon;
    }

    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public Long getCardAccountId() {
        return cardAccountId;
    }

    public void setCardAccountId(Long cardAccountId) {
        this.cardAccountId = cardAccountId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }


    public PresentRecodeFlowDto getPresentRecodeFlowDto() {
        return presentRecodeFlowDto;
    }

    public void setPresentRecodeFlowDto(PresentRecodeFlowDto presentRecodeFlowDto) {
        this.presentRecodeFlowDto = presentRecodeFlowDto;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getMobileNo() {
        return mobileNo;
    }

    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    public String getActiveCode() {
        return activeCode;
    }

    public void setActiveCode(String activeCode) {
        this.activeCode = activeCode;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public int getNum() {
        return num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public Date getCreateTimeBeginTime() {
        return createTimeBeginTime;
    }

    public void setCreateTimeBeginTime(Date createTimeBeginTime) {
        this.createTimeBeginTime = createTimeBeginTime;
    }

    public Date getCreateTimeEndTime() {
        return createTimeEndTime;
    }

    public void setCreateTimeEndTime(Date createTimeEndTime) {
        this.createTimeEndTime = createTimeEndTime;
    }

    public List<String> getChangeTypeList() {
        return changeTypeList;
    }

    public void setChangeTypeList(List<String> changeTypeList) {
        this.changeTypeList = changeTypeList;
    }

    public BigDecimal getGiveAmount() {
        return giveAmount;
    }

    public void setGiveAmount(BigDecimal giveAmount) {
        this.giveAmount = giveAmount;
    }

    public Integer getIsReverse() {
        return isReverse;
    }

    public void setIsReverse(Integer isReverse) {
        this.isReverse = isReverse;
    }
}
