package com.dtyunxi.yundt.cube.biz.account.api.dto.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 会员账户明细信息响应DTO
 * create By chongxu on 2019/7/24
 */
@ApiModel(value = "MemberAccountInfoResqDto", description = "会员账户余额信息响应DTO")
public class MemberAccountInfoResqDto extends BaseRespDto {

    @ApiModelProperty(
            name = "accountId",
            value = "账户Id;"
    )
    @JSONField(name = "memberId")
    private Long accountId;

    @ApiModelProperty(
            name = "changeType",
            value = "账户Id变更类型（01=充值、02=支付、03=充值冲正、04=支付冲正、05=退款/06=赠送积分）;"
    )
    @JSONField(name = "changeType")
    private String changeType;

    @ApiModelProperty(
            name = "tradeId",
            value = "流水;"
    )
    private String tradeId;

    @ApiModelProperty(
            name = "status",
            value = "ROZEN SUCC ROLLBACK;"
    )
    private String status;

    @ApiModelProperty(
            name = "balance",
            value = "账户余额;"
    )
    private BigDecimal balance;

    @ApiModelProperty(
            name = "frozen",
            value = "冻结余额;"
    )
    private BigDecimal frozen;

    @ApiModelProperty(
            name = "disposable",
            value = "任意支配余额;"
    )
    private BigDecimal disposable;
    @ApiModelProperty(
            name = "presentBalance",
            value = "赠送余额;"
    )
    private BigDecimal  presentBalance;
    @ApiModelProperty(
            name = "beforeBalance",
            value = "操作前余额;"
    )
    private BigDecimal beforeBalance;

    @ApiModelProperty(
            name = "beforeFrozen",
            value = "操作前冻结余额;"
    )
    private BigDecimal beforeFrozen;

    @ApiModelProperty(
            name = "beforeDisposable",
            value = "操作前可支配余额;"
    )
    private BigDecimal beforeDisposable;

    @ApiModelProperty(
            name = "tradeAmount",
            value = "交易金额;"
    )
    private BigDecimal tradeAmount;

    @ApiModelProperty(
            name = "tradePrincipalAmount",
            value = "交易本金;"
    )
    private BigDecimal tradePrincipalAmount;

    @ApiModelProperty(
            name = "tradePresentAmount",
            value = "交易赠额;"
    )
    private BigDecimal tradePresentAmount;

    @ApiModelProperty(
            name = "principalBalance",
            value = "本金余额;"
    )
    private BigDecimal principalBalance;

    @ApiModelProperty(
            name = "discountRage",
            value = "折扣率;"
    )
    private BigDecimal discountRage;

    @ApiModelProperty(
            name = "activeCode",
            value = "活动编号;"
    )
    private String activeCode;

    @ApiModelProperty(
            name = "storeCode",
            value = "店铺编号;"
    )
    private String storeCode;

    @ApiModelProperty(
            name = "storeName",
            value = "店铺名称;"
    )
    private String storeName;

    @ApiModelProperty(
            name = "channelCode",
            value = "渠道编码;"
    )
    private String channelCode;

    @ApiModelProperty(
            name = "deviceNo",
            value = "设备号;"
    )
    private String deviceNo;

    @ApiModelProperty(
            name = "businessDate",
            value = "业务时间;"
    )
    private Date businessDate;
    @ApiModelProperty(
            name = "isReverse",
            value = "是否冲正（0=否 1=是）;"
    )
    private Integer isReverse;

    private Long id;

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getFrozen() {
        return frozen;
    }

    public void setFrozen(BigDecimal frozen) {
        this.frozen = frozen;
    }

    public BigDecimal getDisposable() {
        return disposable;
    }

    public void setDisposable(BigDecimal disposable) {
        this.disposable = disposable;
    }

    public BigDecimal getBeforeBalance() {
        return beforeBalance;
    }

    public void setBeforeBalance(BigDecimal beforeBalance) {
        this.beforeBalance = beforeBalance;
    }

    public BigDecimal getBeforeFrozen() {
        return beforeFrozen;
    }

    public void setBeforeFrozen(BigDecimal beforeFrozen) {
        this.beforeFrozen = beforeFrozen;
    }

    public BigDecimal getBeforeDisposable() {
        return beforeDisposable;
    }

    public void setBeforeDisposable(BigDecimal beforeDisposable) {
        this.beforeDisposable = beforeDisposable;
    }

    public BigDecimal getTradeAmount() {
        return tradeAmount;
    }

    public void setTradeAmount(BigDecimal tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public BigDecimal getTradePrincipalAmount() {
        return tradePrincipalAmount;
    }

    public void setTradePrincipalAmount(BigDecimal tradePrincipalAmount) {
        this.tradePrincipalAmount = tradePrincipalAmount;
    }

    public BigDecimal getTradePresentAmount() {
        return tradePresentAmount;
    }

    public void setTradePresentAmount(BigDecimal tradePresentAmount) {
        this.tradePresentAmount = tradePresentAmount;
    }

    public BigDecimal getPrincipalBalance() {
        return principalBalance;
    }

    public void setPrincipalBalance(BigDecimal principalBalance) {
        this.principalBalance = principalBalance;
    }

    public BigDecimal getDiscountRage() {
        return discountRage;
    }

    public void setDiscountRage(BigDecimal discountRage) {
        this.discountRage = discountRage;
    }

    public String getActiveCode() {
        return activeCode;
    }

    public void setActiveCode(String activeCode) {
        this.activeCode = activeCode;
    }

    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public Date getBusinessDate() {
        return businessDate;
    }

    public void setBusinessDate(Date businessDate) {
        this.businessDate = businessDate;
    }

    public BigDecimal getPresentBalance() {
        return presentBalance;
    }

    public void setPresentBalance(BigDecimal presentBalance) {
        this.presentBalance = presentBalance;
    }

    public Integer getIsReverse() {
        return isReverse;
    }

    public void setIsReverse(Integer isReverse) {
        this.isReverse = isReverse;
    }
}
