package com.dtyunxi.yundt.cube.biz.account.api.dto.response;


import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 会员卡账户信息
 * @Author: 小骨
 * @Date 2019/07/02
 * @Version: 0.1.0
 */
@ApiModel(value = "MemberCardAccountRespDto", description = "会员卡信息Dto")
public class MemberCardAccountRespDto extends BaseRespDto {

    @ApiModelProperty(name = "accountType", value = "会员账户类型")
    private String accountType;

    @ApiModelProperty(name = "memberId", value = "会员Id")
    private Long memberId;

    @ApiModelProperty(name = "userId", value = "会员Id")
    private Long userId;

    @ApiModelProperty(name = "memberCode", value = "会员编号")
    private String memberCode;

    @ApiModelProperty(name = "memberName", value = "会员名称")
    private String memberName;

    @ApiModelProperty(name = "customerNo", value = "客户编号")
    private String customerNo;

    @ApiModelProperty(name = "storeCode", value = "店铺编号")
    private String storeCode;

    @ApiModelProperty(name = "memberModelId", value = "会员体系ID")
    private Long memberModelId;

    @ApiModelProperty(name = "phone", value = "手机号")
    private String phone;

    @ApiModelProperty(name = "cardNo", value = "卡号")
    private String cardNo;

    @ApiModelProperty(name = "status", value = "账户状态 激活C ;冻结X;挂失E;注销D;")
    private String status;

    @ApiModelProperty(name = "levelType", value = "会员卡等级 金卡，黑卡，黑钻卡")
    private String levelType;

    @ApiModelProperty(name = "lastConsumeTime", value = "最近消费时间")
    private Date lastConsumeTime;

    @ApiModelProperty(name = "totalConsumeAmount", value = "总消费金额")
    private BigDecimal totalConsumeAmount;

    @ApiModelProperty(name = "totalBalance", value = "总余额")
    private BigDecimal totalBalance;

    @ApiModelProperty(name = "totalAllBalance", value = "累计总额")
    private BigDecimal totalAllBalance;

    @ApiModelProperty(name = "principalBalance", value = "本金余额")
    private BigDecimal principalBalance;

    @ApiModelProperty(name = "presentBalance", value = "赠送余额")
    private BigDecimal presentBalance;

    @ApiModelProperty(name = "discountRage", value = "折扣率")
    private BigDecimal discountRage;

    @ApiModelProperty(name = "passWord", value = "密码")
    private String passWord;

    @ApiModelProperty(name = "businessTime", value = "业务实践")
    private Date businessTime;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(name = "orderCycleMoney", value = "年消费总额")
    private BigDecimal orderCycleMoney;

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    @Override
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public Long getMemberModelId() {
        return memberModelId;
    }

    public void setMemberModelId(Long memberModelId) {
        this.memberModelId = memberModelId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getLevelType() {
        return levelType;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public Date getLastConsumeTime() {
        return lastConsumeTime;
    }

    public void setLastConsumeTime(Date lastConsumeTime) {
        this.lastConsumeTime = lastConsumeTime;
    }

    public BigDecimal getTotalConsumeAmount() {
        return totalConsumeAmount;
    }

    public void setTotalConsumeAmount(BigDecimal totalConsumeAmount) {
        this.totalConsumeAmount = totalConsumeAmount;
    }

    public BigDecimal getTotalBalance() {
        return totalBalance;
    }

    public void setTotalBalance(BigDecimal totalBalance) {
        this.totalBalance = totalBalance;
    }

    public BigDecimal getPrincipalBalance() {
        return principalBalance;
    }

    public void setPrincipalBalance(BigDecimal principalBalance) {
        this.principalBalance = principalBalance;
    }

    public BigDecimal getDiscountRage() {
        return discountRage;
    }

    public void setDiscountRage(BigDecimal discountRage) {
        this.discountRage = discountRage;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public BigDecimal getTotalAllBalance() {
        return totalAllBalance;
    }

    public String getPassWord() {
        return passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public void setTotalAllBalance(BigDecimal totalAllBalance) {
        this.totalAllBalance = totalAllBalance;
    }

    public Date getBusinessTime() {
        return businessTime;
    }

    public void setBusinessTime(Date businessTime) {
        this.businessTime = businessTime;
    }

    public BigDecimal getPresentBalance() {
        return presentBalance;
    }

    public void setPresentBalance(BigDecimal presentBalance) {
        this.presentBalance = presentBalance;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public BigDecimal getOrderCycleMoney() {
        return orderCycleMoney;
    }

    public void setOrderCycleMoney(BigDecimal orderCycleMoney) {
        this.orderCycleMoney = orderCycleMoney;
    }
}
