package com.dtyunxi.yundt.cube.biz.account.api.dto.response;


import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @Description: 会员卡支付结果Dto
 * @Author: 水镜
 * @Date: 2019/7/5 15:47
 * @Version: 0.1.0
 */
@ApiModel(value = "MemberCardPayRespDto", description = "会员卡支付结果Dto")
public class MemberCardPayRespDto extends BaseRespDto {

    /**
     * 会员id
     */
    @ApiModelProperty(name = "memberId", value = "会员id")
    private Long memberId;
    /**
     * 店铺编号
     */
    @ApiModelProperty(name = "storeNo", value = "店铺编号")
    private String storeNo;
    /**
     * 订单编号
     */
    @ApiModelProperty(name = "orderNo", value = "订单编号")
    private String orderNo;
    /**
     * 交易流水号
     */
    @ApiModelProperty(name = "tradeId", value = "交易流水号")
    private String tradeId;
    /**
     * 支付总额
     */
    @ApiModelProperty(name = "payAmount", value = "支付总额")
    private BigDecimal payAmount;
    /**
     * 支付本金
     */
    @ApiModelProperty(name = "payPrincipal", value = "支付本金")
    private BigDecimal payPrincipal;
    /**
     * 支付赠额
     */
    @ApiModelProperty(name = "payPresent", value = "支付赠额")
    private BigDecimal payPresent;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getStoreNo() {
        return storeNo;
    }

    public void setStoreNo(String storeNo) {
        this.storeNo = storeNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getPayPrincipal() {
        return payPrincipal;
    }

    public void setPayPrincipal(BigDecimal payPrincipal) {
        this.payPrincipal = payPrincipal;
    }

    public BigDecimal getPayPresent() {
        return payPresent;
    }

    public void setPayPresent(BigDecimal payPresent) {
        this.payPresent = payPresent;
    }
}
