package com.dtyunxi.yundt.cube.biz.account.api.dto.response;

import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Description: 会员卡退款结果Dto
 * @Author: 水镜
 * @Date: 2019/7/18 16:48
 * @Version: 0.1.0
 */
@ApiModel(value = "MemberCardRefundRespDto", description = "会员卡退款结果Dto")
public class MemberCardRefundRespDto extends BaseRespDto {

    /**
     * 会员id
     */
    @ApiModelProperty(name = "memberId", value = "会员id")
    @NotNull
    private Long memberId;
    /**
     * 店铺编号
     */
    @ApiModelProperty(name = "storeNo", value = "店铺编号")
    private String storeNo;
    /**
     * 原订单号
     */
    @ApiModelProperty(name = "orderNo", value = "原订单号")
    private String orderNo;
    /**
     * 退单号
     */
    @ApiModelProperty(name = "returnOrderNo", value = "退单号")
    private String returnOrderNo;
    /**
     * 退款金额
     */
    @ApiModelProperty(name = "refundAmount", value = "退款金额")
    private BigDecimal refundAmount;
    /**
     * 收银机号
     */
    @ApiModelProperty(name = "deviceNo", value = "收银机号")
    private String deviceNo;
    /**
     * 账户余额
     */
    @ApiModelProperty(name = "balance", value = "账户余额")
    private BigDecimal balance;

    @ApiModelProperty(name = "presentRecodeFlowDto", value = "赠送信息")
    private PresentRecodeFlowDto presentRecodeFlowDto;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getStoreNo() {
        return storeNo;
    }

    public void setStoreNo(String storeNo) {
        this.storeNo = storeNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getReturnOrderNo() {
        return returnOrderNo;
    }

    public void setReturnOrderNo(String returnOrderNo) {
        this.returnOrderNo = returnOrderNo;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public PresentRecodeFlowDto getPresentRecodeFlowDto() {
        return presentRecodeFlowDto;
    }

    public void setPresentRecodeFlowDto(PresentRecodeFlowDto presentRecodeFlowDto) {
        this.presentRecodeFlowDto = presentRecodeFlowDto;
    }
}
