package com.dtyunxi.yundt.cube.biz.account.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @浮云 会员支付FTP传输Dto
 * E097961395781EE78FB78B0106F070D1&1101178399&56675667135161&1&10.00&&56675667120170521082759100&5667&20170521&082759&0.01
 */
@ApiModel(value = "MemberPaySyncDto", description = "会员支付FTP传输Dto")
public class MemberPaySyncDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(name = "guid", value = "guid")
    private String guid;

    @ApiModelProperty(name = "memberId", value = "memberId")
    private String memberId;

    @ApiModelProperty(name = "orderId", value = "orderId")
    private String orderId;

    @ApiModelProperty(name = "type", value = "type")
    private String type;

    @ApiModelProperty(name = "amt", value = "amt，退款写入FTP时写负值")
    private String amt;

    @ApiModelProperty(name = "amt2", value = "amt2，赠送金额")
    private String amt2;

    @ApiModelProperty(name = "couponid", value = "couponid")
    private String couponid;

    @ApiModelProperty(name = "paymentcode", value = "paymentcode")
    private String paymentcode;

    @ApiModelProperty(name = "storeId", value = "storeId")
    private String storeId;

    @ApiModelProperty(name = "crdat", value = "crdat")
    private String crdat;

    @ApiModelProperty(name = "crtim", value = "crtim")
    private String crtim;

    /**
     * 生成code，E097961395781EE78FB78B0106F070D1&1101178399&56675667135161&1&10.00&&56675667120170521082759100&5667&20170521&082759&0.01
     *
     * @return
     */
    public String gernateCode() {
        StringBuffer sb = new StringBuffer()
                .append(StringUtils.isNotBlank(guid) ? guid : "").append("&")
                .append(StringUtils.isNotBlank(memberId) ? memberId : "").append("&")
                .append(StringUtils.isNotBlank(orderId) ? orderId : "").append("&")
                .append(StringUtils.isNotBlank(type) ? type : "").append("&")
                .append(StringUtils.isNotBlank(amt) ? amt : "").append("&")
                .append(StringUtils.isNotBlank(amt2) ? amt2 : "").append("&")
                .append(StringUtils.isNotBlank(couponid) ? couponid : "").append("&")
                .append(StringUtils.isNotBlank(paymentcode) ? paymentcode : "").append("&")
                .append(StringUtils.isNotBlank(storeId) ? storeId : "").append("&")
                .append(StringUtils.isNotBlank(crdat) ? crdat : "").append("&")
                .append(StringUtils.isNotBlank(crtim) ? crtim : "");
        return sb.toString();
    }

    public static void main(String[] args) {
        //E097961395781EE78FB78B0106F070D1&1101178399&56675667135161&1&10.00&&56675667120170521082759100&5667&20170521&082759&0.01
        MemberPaySyncDto memberPaySyncDto = new MemberPaySyncDto();
        memberPaySyncDto.setGuid("E097961395781EE78FB78B0106F070D1");
        memberPaySyncDto.setMemberId("1101178399");
        memberPaySyncDto.setOrderId("56675667135161");
        memberPaySyncDto.setType("1");
        memberPaySyncDto.setAmt("10.00");
        memberPaySyncDto.setAmt2(null);
        memberPaySyncDto.setCouponid("56675667120170521082759100");
        memberPaySyncDto.setPaymentcode("5667");
        memberPaySyncDto.setStoreId("20170521");
        memberPaySyncDto.setCrdat("082759");
        memberPaySyncDto.setCrtim("0.01");
        System.out.println(memberPaySyncDto.gernateCode());
        System.out.println("E097961395781EE78FB78B0106F070D1&1101178399&56675667135161&1&10.00&&56675667120170521082759100&5667&20170521&082759&0.01");
        System.out.printf("==" + "E097961395781EE78FB78B0106F070D1&1101178399&56675667135161&1&10.00&&56675667120170521082759100&5667&20170521&082759&0.01".equals(memberPaySyncDto.gernateCode()));

    }


    public String getGuid() {
        return guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAmt() {
        return amt;
    }

    public void setAmt(String amt) {
        this.amt = amt;
    }

    public String getAmt2() {
        return amt2;
    }

    public void setAmt2(String amt2) {
        this.amt2 = amt2;
    }

    public String getCouponid() {
        return couponid;
    }

    public void setCouponid(String couponid) {
        this.couponid = couponid;
    }

    public String getPaymentcode() {
        return paymentcode;
    }

    public void setPaymentcode(String paymentcode) {
        this.paymentcode = paymentcode;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getCrdat() {
        return crdat;
    }

    public void setCrdat(String crdat) {
        this.crdat = crdat;
    }

    public String getCrtim() {
        return crtim;
    }

    public void setCrtim(String crtim) {
        this.crtim = crtim;
    }
}
