package com.dtyunxi.yundt.cube.biz.account.api.dto.response;

import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;


/**
 * @Description:
 * @Author: 
 * @Date:
 * @Version:
 */
@ApiModel(value = "PresentRecodeFlowDto", description = "会员账户赠送dto")
public class PresentRecodeFlowDto extends BaseRespDto {
    /**
     *  账户流水号
     *
     */
    @ApiModelProperty(name = "accountFlowId", value = "账户流水号")
    private Long accountFlowId;
    /**
     *  关联活动编号
     *
     */
    @ApiModelProperty(name = "presentActivityNo", value = "关联活动编号")
    private String presentActivityNo;
    /**
     *  关联赠礼规则id
     *
     */
    @ApiModelProperty(name = "presentRuleId", value = "关联赠礼规则id")
    private Long presentRuleId;
    /**
     *  充值金额
     *
     */
    @ApiModelProperty(name = "chargeAmount", value = "充值金额")
    private BigDecimal chargeAmount;
    /**
     *  NULL赠送金额
     *
     */
    @ApiModelProperty(name = "presentAmount", value = "NULL赠送金额")
    private BigDecimal presentAmount;
    /**
     *  赠送积分
     *
     */
    @ApiModelProperty(name = "presentPoint", value = "赠送积分")
    private String presentPoint;

    /**
     *  赠送券
     *
     */
    @ApiModelProperty(name = "presentCoupon", value = "赠送券")
    private String presentCoupon;

    /**
     * 赠送的券码编号， 多个用逗号隔开
     */
    @ApiModelProperty(name = "presentCouponCode", value = "赠送的券码编号， 多个用逗号隔开")
    private String presentCouponCode;

    @ApiModelProperty(name = "couponTemplateCodes", value = "优惠券模板编码集合")
    private List<String> couponTemplateCodes;

    @ApiModelProperty(name = "couponCodes", value = "优惠券编码集合")
    private List<String> couponCodes;

    public Long getAccountFlowId() {
        return accountFlowId;
    }

    public void setAccountFlowId(Long accountFlowId) {
        this.accountFlowId = accountFlowId;
    }

    public String getPresentActivityNo() {
        return presentActivityNo;
    }

    public void setPresentActivityNo(String presentActivityNo) {
        this.presentActivityNo = presentActivityNo;
    }

    public Long getPresentRuleId() {
        return presentRuleId;
    }

    public void setPresentRuleId(Long presentRuleId) {
        this.presentRuleId = presentRuleId;
    }

    public BigDecimal getChargeAmount() {
        return chargeAmount;
    }

    public void setChargeAmount(BigDecimal chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    public BigDecimal getPresentAmount() {
        return presentAmount;
    }

    public void setPresentAmount(BigDecimal presentAmount) {
        this.presentAmount = presentAmount;
    }

    public String getPresentPoint() {
        return presentPoint;
    }

    public void setPresentPoint(String presentPoint) {
        this.presentPoint = presentPoint;
    }

    public String getPresentCoupon() {
        return presentCoupon;
    }

    public void setPresentCoupon(String presentCoupon) {
        this.presentCoupon = presentCoupon;
    }

    public String getPresentCouponCode() {
        return presentCouponCode;
    }

    public void setPresentCouponCode(String presentCouponCode) {
        this.presentCouponCode = presentCouponCode;
    }

    public List<String> getCouponTemplateCodes() {
        return couponTemplateCodes;
    }

    public void setCouponTemplateCodes(List<String> couponTemplateCodes) {
        this.couponTemplateCodes = couponTemplateCodes;
    }

    public List<String> getCouponCodes() {
        return couponCodes;
    }

    public void setCouponCodes(List<String> couponCodes) {
        this.couponCodes = couponCodes;
    }


}
