package com.dtyunxi.yundt.cube.biz.account.api.dto.response;

import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author sheng.ruhuan
 */
@ApiModel(value = "tradeFlowRespDto", description = "会员卡账户流水Dto")
public class TradeFlowRespDto extends BaseRespDto {
    /**
     *  账户Id
     *
     */
    @ApiModelProperty(name = "accountId", value = "会员账户Id")
    private Long accountId;

    /**
     *  变更类型（01=充值、02=支付、03=充值冲正、04=支付冲正、05=退款/06=赠送积分）
     *
     */
    @ApiModelProperty(name = "changeType", value = "变更类型")
    private String changeType;

    /**
     * 会员id
     */
    @ApiModelProperty(name = "memberId", value = "会员id")
    private Long memberId;

    /**
     *  客户编号
     */
    @ApiModelProperty(name = "memberNo", value = "客户编号")
    private String memberNo;

    /**
     *  流水
     *
     */
    @ApiModelProperty(name = "tradeId", value = "流水")
    private String tradeId;
    /**
     *  ROZEN SUCC ROLLBACK
     *
     */
    @ApiModelProperty(name = "status", value = "status")
    private String status;
    /**
     *  账户余额
     *
     */
    @ApiModelProperty(name = "balance", value = "账户余额")
    private BigDecimal balance;
    /**
     *  冻结余额
     *
     */
    @ApiModelProperty(name = "frozen", value = "冻结余额")
    private BigDecimal frozen;
    /**
     *  任意支配余额
     *
     */
    @ApiModelProperty(name = "disposable", value = "任意支配余额")
    private BigDecimal disposable;
    /**
     *  操作前余额
     *
     */
    @ApiModelProperty(name = "beforeBalance", value = "操作前余额")
    private BigDecimal beforeBalance;
    /**
     *  操作前冻结余额
     *
     */
    @ApiModelProperty(name = "beforeFrozen", value = "操作前冻结余额")
    private BigDecimal beforeFrozen;
    /**
     *  操作前可支配余额
     *
     */
    @ApiModelProperty(name = "beforeDisposable", value = "操作前可支配余额")
    private BigDecimal beforeDisposable;
    /**
     *  交易金额
     *
     */
    @ApiModelProperty(name = "tradeAmount", value = "交易金额")
    private BigDecimal tradeAmount;
    /**
     *  交易本金
     *
     */
    @ApiModelProperty(name = "tradePrincipalAmount", value = "交易本金")
    private BigDecimal tradePrincipalAmount;
    /**
     *  交易赠额
     *
     */
    @ApiModelProperty(name = "tradePresentAmount", value = "交易赠额")
    private BigDecimal tradePresentAmount;
    /**
     *  本金余额
     *
     */
    @ApiModelProperty(name = "principalBalance", value = "本金余额")
    private BigDecimal principalBalance;
    /**
     *  折扣率
     *
     */
    @ApiModelProperty(name = "discountRage", value = "折扣率")
    private BigDecimal discountRage;
    /**
     *  活动编号
     *
     */
    @ApiModelProperty(name = "activeCode", value = "活动编号")
    private String activeCode;
    /**
     *  订单编号
     *
     */
    @ApiModelProperty(name = "orderNo", value = "订单编号")
    private String orderNo;
    /**
     *  退单小票号
     *
     */
    @ApiModelProperty(name = "returnOrderNo", value = "退单小票号")
    private String returnOrderNo;
    /**
     *  店铺编号
     *
     */
    @ApiModelProperty(name = "storeCode", value = "店铺编号")
    private String storeCode;
    /**
     *  店铺名称
     *
     */
    @ApiModelProperty(name = "storeName", value = "店铺名称")
    private String storeName;
    /**
     *  渠道编码
     *
     */
    @ApiModelProperty(name = "channelCode", value = "渠道编码")
    private String channelCode;
    /**
     *  设备号
     *
     */
    @ApiModelProperty(name = "deviceNo", value = "设备号")
    private String deviceNo;
    /**
     *  业务时间
     *
     */
    @ApiModelProperty(name = "businessDate", value = "业务时间")
    private Date businessDate;
    /**
     *  券模板
     *
     */
    @ApiModelProperty(name = "presentCoupon", value = "券模板")
    private String presentCoupon;

    public String getPresentCoupon() {
        return presentCoupon;
    }

    public void setPresentCoupon(String presentCoupon) {
        this.presentCoupon = presentCoupon;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getFrozen() {
        return frozen;
    }

    public void setFrozen(BigDecimal frozen) {
        this.frozen = frozen;
    }

    public BigDecimal getDisposable() {
        return disposable;
    }

    public void setDisposable(BigDecimal disposable) {
        this.disposable = disposable;
    }

    public BigDecimal getBeforeBalance() {
        return beforeBalance;
    }

    public void setBeforeBalance(BigDecimal beforeBalance) {
        this.beforeBalance = beforeBalance;
    }

    public BigDecimal getBeforeFrozen() {
        return beforeFrozen;
    }

    public void setBeforeFrozen(BigDecimal beforeFrozen) {
        this.beforeFrozen = beforeFrozen;
    }

    public BigDecimal getBeforeDisposable() {
        return beforeDisposable;
    }

    public void setBeforeDisposable(BigDecimal beforeDisposable) {
        this.beforeDisposable = beforeDisposable;
    }

    public BigDecimal getTradeAmount() {
        return tradeAmount;
    }

    public void setTradeAmount(BigDecimal tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public BigDecimal getTradePrincipalAmount() {
        return tradePrincipalAmount;
    }

    public void setTradePrincipalAmount(BigDecimal tradePrincipalAmount) {
        this.tradePrincipalAmount = tradePrincipalAmount;
    }

    public BigDecimal getTradePresentAmount() {
        return tradePresentAmount;
    }

    public void setTradePresentAmount(BigDecimal tradePresentAmount) {
        this.tradePresentAmount = tradePresentAmount;
    }

    public BigDecimal getPrincipalBalance() {
        return principalBalance;
    }

    public void setPrincipalBalance(BigDecimal principalBalance) {
        this.principalBalance = principalBalance;
    }

    public BigDecimal getDiscountRage() {
        return discountRage;
    }

    public void setDiscountRage(BigDecimal discountRage) {
        this.discountRage = discountRage;
    }

    public String getActiveCode() {
        return activeCode;
    }

    public void setActiveCode(String activeCode) {
        this.activeCode = activeCode;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getReturnOrderNo() {
        return returnOrderNo;
    }

    public void setReturnOrderNo(String returnOrderNo) {
        this.returnOrderNo = returnOrderNo;
    }

    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public Date getBusinessDate() {
        return businessDate;
    }

    public void setBusinessDate(Date businessDate) {
        this.businessDate = businessDate;
    }
}
