/*
 * *
 *  @(#)ErrorCodeEnum.java 1.0 19-6-21 下午4:51
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * /
 */

package com.dtyunxi.yundt.cube.biz.account.api.exception;

public enum ErrorCodeEnum {
    /**
     * 错误码
     * Created by sumo on 2021/5/25
     */
    ACCOUNT_ERROR("990101", "账户状态异常"),
    ACCOUNT_BALANCE_LOW("990102", "账户余额不足"),
    ACCOUNT_CARD_NO_ALREADY_EXIST("990103", "账户已绑定卡号"),
    ACCOUNT_DISCOURAGE_ERROR("990104", "账户折扣率错误"),
    ACCOUNT_FLOW_NOT_EXIST("990201", "账户流水不存在"),
    ACCOUNT_FLOW_ALREADY_EXIST("990202", "账户流水已存在"),
    ACCOUNT_REFUND_EXCEED("990203", "退回金额大于原单储值支付金额"),
    ACCOUNT_REFUND_FAILURE("990204", "退款失败"),
    ACCOUNT_PAY_REVERSE_ALREADY_EXIST("990205", "支付流水已冲正"),
    ACCOUNT_PAY_REFUND_ALREADY_EXIST("990206", "支付流水已退款"),

    IMPROPER_PARAMETER("980001", "参数不合法"),
    MISSING_PARAMETER("980002", "参数为空"),
    ILLEGAL_AMENDMENTS("980003", "导入数量不合法"),
    INTERNAL_SYSTEM_ERROR("981000", "系统内部错误"),
    INTERNAL_STATUS_ACTIVE("980004", "此账户未激活"),
    INTERNAL_STATUS_DISCOUNT("980005", "折扣率超过上限"),
    SELECT_STATUS_DISCOUNT("980006", "此账户状态无法被冻结/加挂"),
    EXPORT_ERROR("980007", "导出异常:%"),

    SORT_INPUT_FAIL("5011", "sort的输入有误"),
    EXAMPLE_PARSE_FAIL("5012", "解析filter参数时出现错误"),
    ;
    private final String errorCode;
    private final String errorMsg;

    ErrorCodeEnum(String errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }
}
