package com.dtyunxi.yundt.cube.biz.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.account.api.dto.response.AccountFlowRespDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.response.MemberAccountInfoResqDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.response.MemberPaySyncDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Description: 会员卡账户流水查询接口
 * @Author: 水镜
 * @Date: 2019/7/8 20:29
 * @Version: 0.1.0
 */
@Api(tags = {"会员卡账户流水查询接口"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-biz-account-api-query-IAccountFlowQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v1/account/flow", url = "${yundt.cube.center.account.api:}")
public interface IAccountFlowQueryApi {

    /**Integer begin, Integer batchCount
     * 查询会员卡账户支付流水
     * @return
     */
    @GetMapping(value = "/pay/list", produces = "application/json")
    @ApiOperation(value = "查询会员卡账户支付流水", notes = "查询会员卡账户支付流水")
    List<MemberPaySyncDto> queryPayFlow(@NotNull(message = "支付流水日期不能为空") @RequestParam("tradeDate") String tradeDate, @RequestParam("begin") Integer begin, @RequestParam("batchCount") Integer batchCount);

    /**
     * 根据会员id查询支付流水
     * @param memberId 会员id
     * @param startTime 流水开始时间
     * @param endTime 流水结束时间
     * @return
     */
    @GetMapping(value = "/{memberId}/pay/list", produces = "application/json")
    @ApiOperation(value = "根据会员id查询支付流水", notes = "根据会员id查询支付流水")
    RestResponse<List<AccountFlowRespDto>> queryPayFlowByMemberId(@NotNull(message = "会员id不能为空") @PathVariable("memberId") Long memberId,
                                                                  @NotNull(message = "支付开始时间不能为空") @RequestParam(name = "startTime") String startTime,
                                                                  @NotNull(message = "支付结束时间不能为空") @RequestParam(name = "endTime") String endTime);

    @GetMapping("/queryMemberAccountPage")
    @ApiOperation(value = "查询账户余额明细分页", notes = "查询账户余额明细分页")
    RestResponse<PageInfo<MemberAccountInfoResqDto>> queryMemberAccountPage(@NotNull(message = "账户ID不能为空") @RequestParam("cardAccountId") Long cardAccountId,
                                                                            @RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime,
                                                                            @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);
}
