package com.dtyunxi.yundt.cube.biz.account.api.query;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Description: 会员卡账户手机号码查询接口
 * @Author: 冲虚
 * @Date: 2019/8/2 9:29
 * @Version: 0.1.0
 */
@Api(tags = {"会员卡账户手机号码查询接口"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-biz-account-api-query-IAccountPhoneQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v1/account", url = "${yundt.cube.center.account.api:}")
public interface IAccountPhoneQueryApi {

    /**
     * 根据支付编码查询手机号
     * @return
     */
    @GetMapping(value = "/queryAccountPhone", produces = "application/json")
    @ApiOperation(value = "根据支付编码查询手机号", notes = "根据支付编码查询手机号")
    RestResponse queryAccountPhone(@RequestParam("payCode") String payCode);


}
