package com.dtyunxi.yundt.cube.biz.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.AccountQueryReqDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.response.MemberCardAccountRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @Description: 会员卡账户查询接口
 * @Author: 水镜
 * @Date: 2019/7/8 20:29
 * @Version: 0.1.0
 */
@Api(tags = {"会员卡账户查询接口"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-biz-account-api-query-IMemberCardAccountQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v1/account", url = "${yundt.cube.center.account.api:}")
public interface IMemberCardAccountQueryApi {

    /**
     * 分页查询会员卡账户
     * @param reqDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询会员卡账户", notes = "分页查询会员卡账户")
    RestResponse<PageInfo<MemberCardAccountRespDto>> queryByPage(@RequestBody @Valid AccountQueryReqDto reqDto);

}
