package com.dtyunxi.yundt.cube.biz.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.account.api.dto.request.CardFinanceRecordQueryReqDto;
import com.dtyunxi.yundt.cube.biz.account.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Description: 会员卡查询接口
 * @Author: 小骨
 * @Date: 2019/6/28 14:02
 * @Version: 0.1.0
 */
@Api(tags = {"会员卡查询接口"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-biz-account-api-query-IMemberCardQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v1/memberCard", url = "${yundt.cube.center.account.api:}")
public interface IMemberCardQueryApi {

    @GetMapping(value = "/page", produces = "application/json")
    @ApiImplicitParams({@ApiImplicitParam(name = "filter", value = "查询条件json字符串,例如 {name:\"App1\"}", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    @ApiOperation(value = "分页查询会员卡账户列表", notes = "会员卡账户流水信息列表,filter为查询条件的json字符串，内容如下：\n" +
            "示例：\n" +
            "{\n" +
            "\t\"tenantId\": 1,\n" +
            "\t\"instanceId\": 1,\n" +
            "\t\"filters\": [{\n" +
            "\t\t\t\"property\": \"memberCode\",\n" +
            "\t\t\t\"operator\": \"like\",\n" +
            "\t\t\t\"value\": \"%liu%\"\n" +
            "\t\t},\n" +
            "\t\t{\n" +
            "\t\t\t\"property\": \"phone\",\n" +
            "\t\t\t\"operator\": \"eq\",\n" +
            "\t\t\t\"value\": \"158xxxxxx\"\n" +
            "\t\t}\n" +
            "\t],\n" +
            "\t\"orderBy\": \"createTime\",\n" +
            "\t\"orderByDesc\": \"id\",\n" +
            "}")
    RestResponse<PageInfo<MemberCardAccountRespDto>> queryMemberCardAccountByPage(@RequestParam("filter") String filter,
                                                                                  @RequestParam("pageNum") Integer pageNum,
                                                                                  @RequestParam("pageSize") Integer pageSize);


    @GetMapping(value = "/CardFinanceRecord/page", produces = "application/json")
    @ApiImplicitParams({@ApiImplicitParam(name = "filter", value = "查询条件json字符串,例如 {name:\"App1\"}", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "cardAccountId", value = "账户id", dataType = "integer", paramType = "query"),})
    @ApiOperation(value = "分页查询会员卡账户流水列表", notes = "会员卡账户流水信息列表,filter为查询条件的json字符串，内容如下：\n" +
            "示例：\n" +
            "{\n" +
            "\t\"tenantId\": 1,\n" +
            "\t\"instanceId\": 1,\n" +
            "\t\"filters\": [{\n" +
            "\t\t\t\"property\": \"cardAccount\",\n" +
            "\t\t\t\"operator\": \"eq\",\n" +
            "\t\t\t\"value\": \"23232323\"\n" +
            "\t\t},\n" +
            "\t\t{\n" +
            "\t\t\t\"property\": \"type\",\n" +
            "\t\t\t\"operator\": \"eq\",\n" +
            "\t\t\t\"value\": \"01\"\n" +
            "\t\t}\n" +
            "\t],\n" +
            "\t\"orderBy\": \"createTime\",\n" +
            "\t\"orderByDesc\": \"id\",\n" +
            "}")
    RestResponse<PageInfo<CardFinanceRecordRespDto>> queryCardFinanceRecordByPage(@RequestParam(value = "cardAccountId", required = false) Long cardAccountId,
                                                                                  @RequestParam("filter") String filter,
                                                                                  @RequestParam(name = "pageNum", required = false) Integer pageNum,
                                                                                  @RequestParam("type") String type,
                                                                                  @RequestParam(name = "pageSize", required = false) Integer pageSize);

    /**
     * 分页查询会员账户流水列表
     * @param memberId
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/queryMemberFinanceRecordByPage", produces = "application/json")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "memberId", value = "会员id", dataType = "integer", paramType = "query"),})
    @ApiOperation(value = "分页查询会员账户流水列表", notes = "分页查询会员账户流水列表" )
    RestResponse<PageInfo<CardFinanceRecordRespDto>> queryMemberFinanceRecordByPage(@RequestParam(value = "memberId") Long memberId,
                                                                                  @RequestParam(name = "pageNum", required = false) Integer pageNum,
                                                                                  @RequestParam(name = "pageSize", required = false) Integer pageSize);

    /**
     * es分页查询储值卡流水
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/accountFlow/page", produces = "application/json")
    RestResponse<PageInfo<CardFinanceRecordRespDto>> queryAccountFlowByPage(@RequestBody CardFinanceRecordQueryReqDto queryDto);

    /**
     * es导出储值流水
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/accountFlow/exportAccountFlow", produces = "application/json")
    RestResponse<String> exportAccountFlow(@RequestBody CardFinanceRecordQueryReqDto queryDto);

    /**
     * 查询会员账户信息
     *
     * @param id 主键ID
     * @param
     * @return 查询会员卡账户信息详情
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询会员卡账户信息详情", notes = "根据id查询会员卡账户信息详情")
    RestResponse<MemberCardAccountRespDto> queryMemberCardDetail(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id);

    /**
     * 查询会员账户信息
     *
     * @param memberId 主键ID
     * @param
     * @return 查询会员卡账户信息详情
     */
    @GetMapping("/query/{memberId}")
    @ApiOperation(value = "根据memberId查询会员卡账户信息详情", notes = "根据memberId查询会员卡账户信息详情")
    RestResponse<MemberCardAccountRespDto> queryMemberAccountEoByMemberId(@NotNull(message = "memberId不允许为空") @PathVariable("memberId") Long memberId);

    /**
     * 查询会员账户余额
     * @param memberId 会员id
     * @return
     */
    @GetMapping("/queryTotalBalanceByMemberId/{memberId}")
    @ApiOperation(value = "根据memberId查询会员卡账户余额", notes = "根据memberId查询会员卡账户余额")
    RestResponse<BigDecimal> queryTotalBalanceByMemberId(@NotNull(message = "memberId不允许为空") @PathVariable("memberId") Long memberId);

    /**
     * 查询会员是否存在
     * @param memberId
     * @return
     */
    @GetMapping("/query/account/{memberId}")
    @ApiOperation(value = "根据memberId查询会员卡账户是否存在", notes = "根据memberId查询会员卡账户是否存在")
    RestResponse<MemberCardAccountRespDto> queryMemberAccountIsExed(@NotNull(message = "memberId不允许为空") @PathVariable("memberId") Long memberId);

    /**
     * 查询huiyuan dan ge liushui by trade ID
     * @param memberId
     * @param tradeId
     * @param type
     * @return
     * @javadoc
     */
    @GetMapping("/query/cardFinanceRecord")
    @ApiOperation(value = "根据tradeId查询会员trade", notes = "根据tradeId查询会员trade")
    RestResponse<TradeFlowRespDto> queryCardFinanceRecordByTradeId(@RequestParam("memberId") Long memberId, @RequestParam("tradeId") String tradeId, @RequestParam("type") String type);
    /**
     * 查询流水和交易类型查询会员流水信息
     *
     * @param tradeId
     * @param type
     * @return
     * @javadoc
     */
    @GetMapping("/query/cardFinance")
    @ApiOperation(value = "根据tradeId查询会员trade", notes = "根据tradeId查询会员trade")
    RestResponse<TradeFlowRespDto> queryCardFinanceByTradeId(@RequestParam("tradeId") String tradeId, @RequestParam("type") String type);

    /**
     * 根据memberid列表查询储值列表
     * @param memberIdList
     * @return RestResponse
     */
    @PostMapping("/list/amount")
    @ApiOperation(value = "根据memberid列表查询储值列表", notes = "根据memberid列表查询储值列表")
    RestResponse<List<MemberCardBalanceRespDto>> queryAmountByList(@NotNull(message = "memberIdList不允许为空") @RequestBody List<Long> memberIdList);

    /**
     * 根据会员ID查询会员金额
     * @param memberId
     * @return
     */
    @GetMapping("/query/account/information")
    @ApiOperation(value = "根据memberId查询会员全部信息", notes = "根据memberId查询会员全部信息")
    RestResponse<AccountRespDto> queryInformationByMemberId(@RequestParam("memberId") Long memberId);
}
