/**
 * @(#) IAccountApi.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.AccountPreReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.CreateAccForCustomerReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.CreateAccReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.ModifyAccReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 资金账户管理服务
 *
 * @author 风行
 * @since 0.5.0
 */
@Api(tags = {"账户中心：资金账户管理服务"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-account-api-IAccountApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/account", url = "${yundt.cube.center.account.api:}")
public interface IAccountApi {

    /**
     * 资金账户开户接口
     *
     * @param accReqDto
     * @return
     */
    @PostMapping(value = "")
    @ApiOperation(value = "新建账户", notes = "新建账户")
    RestResponse<CreateAccRespDto> createAccount(@Valid @RequestBody CreateAccReqDto accReqDto);

    /**
     * 修改账户信息
     *
     * @param accReqDto
     * @return
     */
    @PutMapping(value = "")
    @ApiOperation(value = "修改账户", notes = "修改账户")
    RestResponse<ModifyAccRespDto> modifyAccount(@Valid @RequestBody ModifyAccReqDto accReqDto);

    /**
     * 销户
     *
     * @param id
     * @return
     */
    @DeleteMapping(value = "/{id}")
    @ApiOperation(value = "销毁账户", notes = "销毁账户")
    RestResponse<DestroyAccRespDto> destroyAccount(@PathVariable("id") Long id);

    /**
     * 更新账户状态
     *
     * @param id
     * @return
     */
    @PutMapping(value = "{id}/status/{status}")
    @ApiOperation(value = "更新账户状态", notes = "更新账户状态")
    RestResponse<ModifyAccStatusRespDto> modifyAccountStatus(@PathVariable("id") Long id, @PathVariable("status") String status);


    /**
     * 客商开户接口
     *
     * @param accReqDto
     * @return
     */
    @PostMapping(value = "/customer")
    @ApiOperation(value = "新建账户(客商)", notes = "新建账户（客商）")
    RestResponse<CreateAccRespDto> createAccountForCustomer(@RequestBody CreateAccForCustomerReqDto accReqDto);



}
