/*
 * @(#)IAccountPwdApi.java 1.0 2021年05月20日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api;

/**
 * <p>Title:IAccountPwdApi</p>
 * <p>Description: </p>
 *
 * @author 勉之
 * @date 2021/5/20 19:07
 * @since 0.1.0
 */

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.ModifyAccPwdReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.QueryAccPwdReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = {"账户中心：资金账户密码服务"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-account-api-IAccountPwdApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/account/pwd", url = "${yundt.cube.center.account.api:}")
public interface IAccountPwdApi {

    @PostMapping(value = "/adminReset")
    @ApiOperation(value = "管理员重置账户密码", notes = "管理员重置账户密码" +
            "\n accountId: 账户id"
    )
    RestResponse<String> adminResetPwd(@RequestBody ModifyAccPwdReqDto modifyAccPwdReqDto);

    @PostMapping(value = "/init")
    @ApiOperation(value = "用户初始化账户密码", notes = "用户初始化账户密码 " +
            "\n userType:用户类型- " +
            "\n userId: 用户id " +
            "\n newPwd 新密码")
    RestResponse<Boolean> initAccountPwd(@RequestBody ModifyAccPwdReqDto modifyAccPwdReqDto);

    @PostMapping(value = "/reset")
    @ApiOperation(value = "用户重置密码", notes = "用户重置密码 " +
            "\n userType:用户类型- " +
            "\n userId: 用户id " +
            " \n newPwd： 新密码" +
            " \n oldPwd： 旧密码")
    RestResponse<Boolean> userResetPwd(@RequestBody ModifyAccPwdReqDto modifyAccPwdReqDto);

    @PostMapping(value = "/checkRight")
    @ApiOperation(value = "校验密码正确", notes = "校验密码正确 "+
            "\n userType:用户类型" +
            "\n userId: 用户id " +
            " \n oldPwd： 旧密码" )
    RestResponse<Boolean> checkPwdRight(@RequestBody QueryAccPwdReqDto queryAccPwdReqDto);

    @GetMapping(value = "/queryHasSet")
    @ApiOperation(value = "查询密码是否设置", notes = "queryAccPwdReqDto:"+
            "\n userType:用户类型" +
            "\n userId: 用户id " )
    RestResponse<Boolean> queryPwdHasSet(QueryAccPwdReqDto queryAccPwdReqDto);

}
