/**
 * @(#) IAccountApi.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.AddAccountRechargeOrderReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.AddAccountRechargeOrderReqToBDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.PayRechargeOrderReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.AddAccountRechargeOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @des 充值订单接口服务
 * @author lengqian
 * @data 2019/08/05
 */
@Api(tags = {"账户中心：充值订单管理服务"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-account-api-IAccountRechargeOrderApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/recharge", url = "${yundt.cube.center.account.api:}")
public interface IAccountRechargeOrderApi {

    /**
     * 充值订单下单
     * @param addAccountRechargeOrderReqDto
     * @return
     */
    @PostMapping(value = "")
    @ApiOperation(value = "充值订单下单", notes = "充值订单下单")
    RestResponse<String> addRechargeOrder(@Valid @RequestBody AddAccountRechargeOrderReqDto addAccountRechargeOrderReqDto);

    /**
     * 充值订单下单
     * @param addAccountRechargeOrderReqDto
     * @return
     */
    @PostMapping(value = "add")
    @ApiOperation(value = "B端充值订单下单", notes = "充值订单下单")
    RestResponse<AddAccountRechargeOrderRespDto> addRechargeOrderToB(@Valid @RequestBody AddAccountRechargeOrderReqToBDto addAccountRechargeOrderReqDto);
    /**
     * B端录入线下充值单
     *
     * @param addAccountRechargeOrderReqDto
     * @return
     */
    @PostMapping(value = "refer/add")
    @ApiOperation(value = "B端录入线下充值单", notes = "录入线下充值单")
    RestResponse<AddAccountRechargeOrderRespDto> referAddRechargeOrderToB(@Valid @RequestBody AddAccountRechargeOrderReqToBDto addAccountRechargeOrderReqDto);

    /**
     * 更新充值订单状态
     * @param orderNo
     * @param status
     * @return
     */
    @PutMapping(value = "{orderNo}/status/{status}")
    @ApiOperation(value = "更新充值订单状态", notes = "更新充值订单状态")
    RestResponse<Void> modifyRechargeOrderStatus(@PathVariable("orderNo") String orderNo, @PathVariable("status") String status);
    /**
     * 充值单财务审核
     * @param orderNo
     * @param status
     * @return
     */
    @PutMapping(value = "{orderNo}/financial/adu/{status}")
    @ApiOperation(value = "充值单财务审核", notes = "更新充值订单状态:PASS-审核通过,REJECT-已驳回")
    RestResponse<Void> modifyRechargeOrderFinancialStatus(@PathVariable("orderNo") String orderNo, @PathVariable("status") String status);

    /**
     * 充值订单支付
     * @param payRechargeOrderReqDto
     * @return
     */
    @PostMapping(value = "/payOrder")
    @ApiOperation(value = "充值订单支付", notes = "充值订单支付")
    RestResponse<String> payRechargeOrder(@Valid @RequestBody PayRechargeOrderReqDto payRechargeOrderReqDto);

}
