/*
 * @(#)ICardApi.java 1.0 2018-10-29
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.AquiredBindCardReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.ConfirmBindCardReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.AquiredBindCardRespDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.ConfirmBindCardRespDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.RemoveBindCardRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 资金账户管理服务
 *
 * @author 风行
 * @since 0.5.0
 */
@Api(tags = {"账户中心：资金账户银行卡管理服务"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-account-api-ICardApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/card", url = "${yundt.cube.center.account.api:}")
public interface ICardApi {

    /**
     * 请求绑定银行卡
     *
     * @param bindCardReqDto
     * @return
     */
    @PostMapping(value = "/account/{accountId}")
    @ApiOperation(value = "请求绑定银行卡", notes = "请求绑定银行卡")
    RestResponse<AquiredBindCardRespDto> aquiredBindCard(@PathVariable("accountId") Long accountId, @Valid @RequestBody AquiredBindCardReqDto bindCardReqDto);

    /**
     * 确认绑定银行卡
     *
     * @param cardReqDto
     * @return
     */
    @PutMapping(value = "/account/{accountId}")
    @ApiOperation(value = "确认绑定银行卡", notes = "确认绑定银行卡")
    RestResponse<ConfirmBindCardRespDto> confirmBindCard(@PathVariable("accountId") Long accountId, @Valid @RequestBody ConfirmBindCardReqDto cardReqDto);

    /**
     * 解绑银行卡
     *
     * @param id
     * @return
     */
    @DeleteMapping(value = "/{id}")
    @ApiOperation(value = "解绑银行卡", notes = "解绑银行卡")
    RestResponse<RemoveBindCardRespDto> removeBindCard(@PathVariable("id") Long id);
}
