package com.dtyunxi.yundt.cube.center.account.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.PayeeConfigSaveReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;


@Api(tags = {"收款配置"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-biz-account-api-IPayeeConfigApi",
        name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}",
        path = "/v1/payee-config", url = "${yundt.cube.center.account.api:}")
public interface IPayeeConfigApi {


    @PostMapping(value = "/add", produces = "application/json")
    @ApiOperation(value = "保存收款配置", notes = "保存收款配置")
    RestResponse<Long> addPayeeConfig(@RequestBody @Valid PayeeConfigSaveReqDto dto);

}