/**
 * @(#) ITransactionApi.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.tran.BaseTranRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

/**
 * @author 风行
 * @since 0.5.0
 */
@Api(tags = {"账户中心：资金账户交易管理服务"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-account-api-ITransactionApi",
        name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}",
        path = "/v2/transaction",
        url = "${yundt.cube.center.account.api:}")
public interface ITransactionApi {

    /**
     * 创建交易
     * @param request
     * @param <R>
     * @return
     */
    @PostMapping(value = "/tranType/{tranType}")
    @ApiOperation(value = "新建交易", notes = "新建交易\t\n " +
            "map:账户交易封装对象JSON {\n" +
            "    \"accountId\": long,\n" +
            "    \"tradeId\": \"string\",\n" +
            "    \"tranAmt\": 100,\n" +
            "    \"payeeAccountId\": 123转账收款人,\n" +
            "    \"instanceId\": 0,\n" +
            "    \"tenantId\": 0\n" +
            "}")
    <R extends BaseTranRespDto> RestResponse<R> doTransaction(@PathVariable("tranType") String tranType, @RequestBody Map<String, Object> request) throws Exception;

    /**
     * 修改交易
     * @param request
     * @param <R>
     * @return
     */
    @PutMapping(value = "/tranType/{tranType}")
    @ApiOperation(value = "修改交易", notes = "修改交易\t\n " +
            "map:账户交易封装对象JSON {\n" +
            "    \"accountId\": long,\n" +
            "    \"tradeId\": \"string\",\n" +
            "    \"tranAmt\": 100,\n" +
            "    \"payeeAccountId\": 123转账收款人,\n" +
            "    \"instanceId\": 0,\n" +
            "    \"tenantId\": 0\n" +
            "}")
    <R extends BaseTranRespDto> RestResponse<R> modifyTransaction(@PathVariable("tranType") String tranType, @RequestBody Map<String, Object> request)throws Exception;
}
