/**
 * @(#) IAccountApi.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw.WithdrawApplyReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw.WithdrawDoReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw.WithdrawRuleReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw.WithdrawUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 提现管理
 */
@Api(tags = {"账户中心：提现管理"})
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-account-api-IWithdrawApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/withdraw", url = "${yundt.cube.center.account.api:}")
public interface IWithdrawApi {

    /**
     * 新增或保存提现规则
     *
     * @param withdrawRuleReqDto
     * @return
     */
    @PostMapping(value = "/rule")
    @ApiOperation(value = "新增或保存提现规则", notes = "新增或保存提现规则")
    RestResponse<Long> saveWithdrawRule(@Valid @RequestBody WithdrawRuleReqDto withdrawRuleReqDto);

    /**
     * 新增提现单
     *
     * @param withdrawApplyReqDto
     * @return
     */
    @PutMapping(value = "")
    @ApiOperation(value = "新增提现单", notes = "新增提现单")
    RestResponse<Long> addWithdraw(@Valid @RequestBody WithdrawApplyReqDto withdrawApplyReqDto);

    /**
     * 审核提现单
     *
     * @param withdrawUpdateReqDto
     * @return
     */
    @PostMapping(value = "")
    @ApiOperation(value = "修改提现单", notes = "修改提现单")
    RestResponse<Long> updateWithdraw(@Valid @RequestBody WithdrawUpdateReqDto withdrawUpdateReqDto);

    /**
     * 提现打款
     *
     * @param withdrawDoReqDto
     * @return
     */
    @PostMapping(value = "/pay")
    @ApiOperation(value = "提现打款", notes = "修改提现单")
    RestResponse<Long> withdrawPay(@RequestBody WithdrawDoReqDto withdrawDoReqDto);

}
