/**
 * @(#) IAccountApi.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw.WithdrawApplyReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw.WithdrawConfirmReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw.WithdrawDoReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @des 佣金提现申请单管理
 * @author lengqian
 * @data 20120/03/05
 */
@Api(tags = {"账户中心：佣金提现申请单管理"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-account-api-IWithdrawApplyRecordApi",name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/withdraw/apply", url = "${yundt.cube.center.account.api:}")
public interface IWithdrawApplyRecordApi {

    /**
     * 佣金提现申请
     * @param withdrawApplyReqDto
     * @return
     */
    @PostMapping(value = "apply")
    @ApiOperation(value = "佣金提现申请", notes = "佣金提现申请")
    RestResponse<Long> apply(@Valid @RequestBody WithdrawApplyReqDto withdrawApplyReqDto);

    /**
     * 申请确认
     * @param withdrawConfirmReqDto
     * @return
     */
    @PostMapping(value = "confirm")
    @ApiOperation(value = "申请确认", notes = "申请确认")
    RestResponse<Long> confirm(@Valid @RequestBody WithdrawConfirmReqDto withdrawConfirmReqDto);

    /**
     * 提现
     * @param withdrawDoReqDto
     * @return
     */
    @PostMapping(value = "withdraw")
    @ApiOperation(value = "提现", notes = "提现")
    RestResponse<Long> doWithdraw(@Valid @RequestBody WithdrawDoReqDto withdrawDoReqDto);

    /**
     * 管理后台手动操作提现
     * @param withdrawDoReqDto
     * @return
     */
    @PostMapping(value = "withdraw/by-manager")
    @ApiOperation(value = "管理后台手动操作提现", notes = "管理后台手动操作提现")
    RestResponse<Long> doWithdrawByManager(@Valid @RequestBody WithdrawDoReqDto withdrawDoReqDto);

}
