/**
 * @(#) Constants.java 1.0 2018-09-20
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.constants;

/**
 * @author 风行
 * @since 2.0.0
 */
public class Constants {

    /**账户类型*/
    /** 普通帐号 */
    public static final String ACCOUNT_TYPE_NORMAL = "NORMAL";
    /** 手续费帐号 */
    public static final String ACCOUNT_TYPE_FEE = "FEE";
    /** 主帐号 */
    public static final String ACCOUNT_TYPE_SUPPER = "SUPPER";
    /** 担保帐号 */
    public static final String ACCOUNT_TYPE_WARRANT = "WARRANT";
    /** 信用帐号 */
    public static final String ACCOUNT_TYPE_CREDIT = "CREDIT";
    /** 信用主帐号 */
    public static final String ACCOUNT_TYPE_CREDIT_SUPPER = "CREDIT_SUPPER";
    /** 分销佣金账户 */
    public static final String ACCOUNT_TYPE_DISTRIBUTION = "DISTRIBUTION";


    /**
     * 账户用户类型:个人平台级账户-PERSONAL_PLATFORM
     */
    public static final String ACCOUNT_USER_TYPE_PERSONAL_PLATFORM = "PERSONAL_PLATFORM";
    /**
     * 账户用户类型:个人会员级账户-PERSONAL_MEMBER
     */
    public static final String ACCOUNT_USER_TYPE_PERSONAL_MEMBER = "PERSONAL_MEMBER";
    /**
     * 账户用户类型:企业用户账户-ENTERPRISE
     */
    public static final String ACCOUNT_USER_TYPE_ENTERPRISE = "ENTERPRISE";

    /**
     * 账户状态：激活
     */
    public static final String ACCOUNT_STATUS_ENABLED = "ENABLED";
    /**
     * 账户状态：冻结
     */
    public static final String ACCOUNT_STATUS_LOCK = "LOCK";
    /**
     * 账户状态：注销
     */
    public static final String ACCOUNT_STATUS_FORBIDDEN = "FORBIDDEN";

    /**账户操作类型*/
    public static final String ACCOUNT_OP_TYPE_MODIFY = "MODIFY";
    public static final String ACCOUNT_OP_TYPE_LOCK = "LOCK";
    public static final String ACCOUNT_OP_TYPE_DESTROY = "DESTROY";
    public static final String ACCOUNT_OP_TYPE_RELEASE = "RELEASE";

    /**账户资金交易类型*/
    /** 充值 */
    public static final String ACCOUNT_BALANCE_OP_TYPE_RECHARGE = "RECHARGE";
    /** 充值退回 */
    public static final String ACCOUNT_BALANCE_OP_TYPE_RECHARGEBACK = "RECHARGEBACK";
    /** 转账 */
    public static final String ACCOUNT_BALANCE_OP_TYPE_TRANSFER = "TRANSFER";
    /** 支付 */
    public static final String ACCOUNT_BALANCE_OP_TYPE_PAY = "PAY";
    /** 支付冲正*/
    public static final String ACCOUNT_BALANCE_OP_TYPE_PAY_RECHARGEBACK = "PAY_RECHARGEBACK";
    /** 撤回 */
    public static final String ACCOUNT_BALANCE_OP_TYPE_WITHDRAW = "WITHDRAW";
    /** 提现(不需要短信校验) */
    public static final String ACCOUNT_BALANCE_OP_TYPE_WITHDRAW_WITHOUT_VERIFY = "WITHDRAW_NOT_VERIFY";
    /** 退款 */
    public static final String ACCOUNT_BALANCE_OP_TYPE_REFUND = "REFUND";
    /** 分销佣金到账 */
    public static final String ACCOUNT_BALANCE_OP_TYPE_DISTRIBUTION_ADD = "DISTRIBUTION_ADD";
    /** 分销佣金提现 */
    public static final String ACCOUNT_BALANCE_OP_TYPE_DISTRIBUTION_WITHDRAW = "DISTRIBUTION_WITHDRAW";

    /**账户资金操作状态*/
    /** 等待 */
    public static final String ACCOUNT_BALANCE_OP_STATUS_FROZEN = "FROZEN";
    /** 成功 */
    public static final String ACCOUNT_BALANCE_OP_STATUS_SUCC = "SUCC";
    public static final String ACCOUNT_BALANCE_OP_STATUS_ROLLBACK = "ROLLBACK";

    public static final String COLON = ":";

    /**验证码有效期*/
    public static final String VERIFY_CODE_SMS_VALID_TIME = "verifyCode.smsValidTime";
    /**验证码长度*/
    public static final String VERIFY_CODE_LENGTH = "verifyCode.length";
    /**验证码模版*/
    public static final String VERIFY_CODE_TEMPLATE = "verifyCode.template";
    /**验证码模版占位符*/
    public static final String VERIFY_CODE_TEMPLATE_PLACEHOLDER = "verifyCode.templatePlaceholder";

    /**记录版本初始值:0*/
    public static final Integer RECORD_VERSION_INIT_VALUE = 0;
    /**调支付时场景信息key:sceneInfo*/
    public static final String SCENE_INFO_KEY = "sceneInfo";
    /**调支付时赠送金额key:giveAmount*/
    public static final String GIVE_AMOUNT_KEY = "giveAmount";

    /**
     * 用户账户充值-1
     */
    public static final Integer RECHARGE_TYPE_USER = 1;

    /**
     * 用户佣金入账充值-2
     */
    public static final Integer RECHARGE_TYPE_SETTLEMENT = 2;

    /**
     * 微信提现备注
     */
    public static final String WX_WITHDRAW_DESC = "微信提现申请";
    /**
     * 微信提现默认ip
     */
    public static final String WX_WITHDRAW_IP = "192.168.0.1";
    /**
     * 时间格式
     */
    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    /**
     * 账户密码状态： 未设置
     */
    public static final Integer ACCOUNT_PWD_UNSET_STATUS = 0 ;
    public static final String  ACCOUNT_PWD_UNSET_STATUS_STR = "未设置" ;
    /**
     * 账户密码状态：已设置
     */
    public static final Integer ACCOUNT_PWD_SET_STATUS = 1 ;
    public static final String  ACCOUNT_PWD_SET_STATUS_STR = "已设置" ;

}
