/*
 * @(#)WithDrawStepEnum.java 1.0 2018-10-30
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.constants;

/**
 * @author 云舒
 * @since 2.0.0
 */
public enum WithDrawStepEnum {

    SUBMIT("SUBMIT", "提交请求"),
    VERIFY("VERIFY", "校验验证码"),
    SUCC("SUCC", "提现成功"),
    FAIL("FAIL", "提现失败");

    private String step;
    private String text;

    private WithDrawStepEnum(String step, String text) {
        this.step = step;
        this.text = text;
    }

    public String getStep() {
        return step;
    }

    public String getText() {
        return text;
    }

    /**
     * 根据step获取text
     *
     * @param step
     *            步骤编码
     * @return 步骤说明
     */
    public static String getText(String step) {
        if (step == null) {
            return null;
        }
        for (WithDrawStepEnum withDrawStepEnum : WithDrawStepEnum.values()) {
            if (step.equals(withDrawStepEnum.getStep())) {
                return withDrawStepEnum.getText();
            }
        }
        return null;
    }

}
