package com.dtyunxi.yundt.cube.center.account.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 收款配置保存dto
 * Created by sumo on 2021/5/20
 */
@ApiModel(value = "PayeeConfigSaveReqDto", description = "收款配置保存dto")
public class PayeeConfigSaveReqDto extends RequestDto {

    /**
     * id
     */
    @ApiModelProperty(value="id")
    private Long id;

    /**
     * 收款方id:平台或经销商id
     */
    @ApiModelProperty(value="收款方id:平台或经销商id")
    private Long payeeId;


    /**
     * 是否允许自定义金额(1是2否)
     */
    @ApiModelProperty(value="是否允许自定义金额(1是2否),默认为允许")

    private Integer enableCustomAmt=1;

    /**
     * 默认充值金额配置
     */
    @ApiModelProperty(value = "默认充值金额配置,金额格式如123.22,45.00(不要重复,数量由前端控制)", required = true)
    @NotNull(message = "不能为空")
    private List<BigDecimal> defaultAmtList;

    /**
     * 是否启用代客下单余额支付(1是2否)
     */
    @ApiModelProperty(value="是否启用代客下单余额支付(1是2否),默认为启用")
    private Integer enableAgentPay=1;

    /**
     * 是否隐藏代客下单显示账户余额(1是2否)
     */
    @ApiModelProperty(value="是否隐藏代客下单显示账户余额(1是2否),默认为启用")

    private Integer hideAmt=1;

    /**
     * 收款方商家开户名称
     */
    @ApiModelProperty(value="收款方商家开户名称")
    private String payeeAccountName;

    /**
     * 收款方商家卡号银行
     */
    @ApiModelProperty(value="收款方商家卡号银行")
    private String payeeBankName;

    /**
     * 收款方商家开户账户
     */
    @ApiModelProperty(value="收款方商家开户账户")
    private String payeeAccountNo;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(Long payeeId) {
        this.payeeId = payeeId;
    }

    public Integer getEnableCustomAmt() {
        return enableCustomAmt;
    }

    public void setEnableCustomAmt(Integer enableCustomAmt) {
        this.enableCustomAmt = enableCustomAmt;
    }

    public List<BigDecimal> getDefaultAmtList() {
        return defaultAmtList;
    }

    public void setDefaultAmtList(List<BigDecimal> defaultAmtList) {
        this.defaultAmtList = defaultAmtList;
    }

    public Integer getEnableAgentPay() {
        return enableAgentPay;
    }

    public void setEnableAgentPay(Integer enableAgentPay) {
        this.enableAgentPay = enableAgentPay;
    }

    public Integer getHideAmt() {
        return hideAmt;
    }

    public void setHideAmt(Integer hideAmt) {
        this.hideAmt = hideAmt;
    }

    public String getPayeeAccountName() {
        return payeeAccountName;
    }

    public void setPayeeAccountName(String payeeAccountName) {
        this.payeeAccountName = payeeAccountName;
    }

    public String getPayeeBankName() {
        return payeeBankName;
    }

    public void setPayeeBankName(String payeeBankName) {
        this.payeeBankName = payeeBankName;
    }

    public String getPayeeAccountNo() {
        return payeeAccountNo;
    }

    public void setPayeeAccountNo(String payeeAccountNo) {
        this.payeeAccountNo = payeeAccountNo;
    }
}
