/**
 * @(#)AccountFlowReqDto.java 1.0 2020/3/4
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 账户流水
 *
 * @author wu.sheng
 * @date 2020/3/4 11:22
 */
@ApiModel(value = "AccountFlowQueryReqDto", description = "账户流水查询参数")
public class AccountFlowQueryReqDto extends BaseReqDto {

    /**
     * 账户Id
     */
    @ApiModelProperty(name = "accountId", value = "账户Id")
    private Long accountId;

    /**
     * 变更类型（01=充值、02=支付、03=充值冲正、04=支付冲正、05=退款/06=赠送积分）
     */
    @ApiModelProperty(name = "changeType", value = "01=充值、02=支付、03=充值冲正、04=支付冲正、05=退款/06=赠送积分")
    private String changeType;

    /**
     * 账户编号
     */
    @ApiModelProperty(name = "memberNo", value = "账户编号")
    private String memberNo;

    /**
     * 流水
     */
    @ApiModelProperty(name = "tradeId", value = "账户流水号")
    private String tradeId;


    /**
     * 订单编号
     */
    @ApiModelProperty(name = "orderNo", value = "订单号")
    private String orderNo;

    @ApiModelProperty(name = "sqlFilters", value = "自定义sql查询条件")
    private List<SqlFilter> sqlFilters;


    @ApiModelProperty(name = "code", value = "单据号")
    private String code;

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public List<SqlFilter> getSqlFilters() {
        return sqlFilters;
    }

    public void setSqlFilters(List<SqlFilter> sqlFilters) {
        this.sqlFilters = sqlFilters;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
