/*
 * @(#)AccountFlowSearchReqDto.java 1.0 2021年05月18日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <p>Title:AccountFlowSearchReqDto</p>
 * <p>Description: </p>
 *
 * @author 勉之
 * @date 2021/5/18 20:38
 * @since 0.1.0
 */
@ApiModel(value = "AccountFlowSearchReqDto", description = "账户流水post查询参数")
public class AccountFlowSearchReqDto extends BaseReqDto {


    @ApiModelProperty(name = "pageNum", value = "第几页")
    @NotNull(message = "页码不能为空")
    private Integer pageNum ;


    @ApiModelProperty(name = "pageSize", value = "页大小")
    @NotNull(message = "页大小不能为空")
    private Integer pageSize ;


    /**
     * 账户Id
     */
    @NotNull(message = "账户Id不能为空")
    @ApiModelProperty(name = "accountId", value = "账户Id")
    private Long accountId;

    /**
     * 常量定义在constants中：ACCOUNT_BALANCE_OP_TYPE_RECHARGE
     */
    @ApiModelProperty(name = "changeType", value = "recharge:充值，pay:支付，refund:退款")
    private String changeType;

    /**
     * 账户编号
     */
    @ApiModelProperty(name = "memberNo", value = "账户编号")
    private String memberNo;

    /**
     * 流水
     */
    @ApiModelProperty(name = "tradeId", value = "支付流水")
    private String tradeId;

    /**
     * 订单编号
     */
    @ApiModelProperty(name = "orderNo", value = "订单号")
    private String orderNo;


    @ApiModelProperty(name = "code", value = "单据号")
    private String code;

    /**
     * 业务时间-开始
     */
    @ApiModelProperty(name = "busiDateStart", value = "业务时间—开始")
    private String busiDateStart ;
    /**
     * 业务时间-结束
     */
    @ApiModelProperty(name = "busiDateEnd", value = "业务时间—结束")
    private String busiDateEnd ;


    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }


    public String getBusiDateStart() {
        return busiDateStart;
    }

    public void setBusiDateStart(String busiDateStart) {
        this.busiDateStart = busiDateStart;
    }

    public String getBusiDateEnd() {
        return busiDateEnd;
    }

    public void setBusiDateEnd(String busiDateEnd) {
        this.busiDateEnd = busiDateEnd;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

}
