package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@ApiModel(value = "AccountPreReqDto", description = "账号预览")
public class AccountPreReqDto extends BaseReqDto {

    @ApiModelProperty(name = "userId", value = "用户Id-客商传customerId",required = true)
    @NotNull(message = "不能为空")
    private Long userId;

    @ApiModelProperty(name = "needBalance", value = "本次支付金额")
    private BigDecimal needBalance;

    @Override
    public Long getUserId() {
        return userId;
    }

    @Override
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public BigDecimal getNeedBalance() {
        return needBalance;
    }

    public void setNeedBalance(BigDecimal needBalance) {
        this.needBalance = needBalance;
    }
}
