package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @des 新增充值订单
 * @author lengqian
 * @data 2019/08/05
 */
@ApiModel(value = "AddAccountRechargeOrderReqDto", description = "账户中心-新增充值订单")
public class AddAccountRechargeOrderReqDto extends RequestDto {
    /**
     * 用户id
     */
    @ApiModelProperty(name = "userId", value = "用户id")
    private String userId;
    /**
     * 充值账户id
     */
    @ApiModelProperty(name = "accountId", value = "充值账户id")
    @NotNull(message = "充值账户id不能为空")
    private Long accountId;
    /**
     * 赠送金额
     */
    @ApiModelProperty(name = "giveAmount", value = "赠送金额")
    private BigDecimal giveAmount;
    /**
     * 实付金额
     */
    @ApiModelProperty(name = "payAmount", value = "实付金额")
    private BigDecimal payAmount;
    /**
     * 充值金额
     */
    @ApiModelProperty(name = "totalAmount", value = "充值金额（充值金额=赠送金额+实付金额）")
    private BigDecimal totalAmount;
    /**
     * 订单关闭时间(未支付订单过期时间)
     */
    @ApiModelProperty(name = "closeTime", value = "订单关闭时间(未支付订单过期时间)")
    private Date closeTime;
    /**
     * 终端来源类型: 1: app端 2: PC端 3:微信端
     */
    @ApiModelProperty(name = "deviceType", value = "终端来源类型:1:app端2:PC端3:微信端")
    private String deviceType;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public BigDecimal getGiveAmount() {
        return giveAmount;
    }

    public void setGiveAmount(BigDecimal giveAmount) {
        this.giveAmount = giveAmount;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }
}