package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.dto.RequestDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @des 新增充值订单
 * @author lengqian
 * @data 2019/08/05
 */
@ApiModel(value = "AddAccountRechargeOrderReqToBDto", description = "账户中心-新增充值订单")
public class AddAccountRechargeOrderReqToBDto extends RequestDto {
    /**
     * 客户Id
     */
    @ApiModelProperty(name = "customerId", value = "客户Id",required = true)
    @NotNull(message = "不能为空")
    private Long customerId;
    /**
     * 充值账户id
     */
    @ApiModelProperty(name = "accountId", value = "充值账户id,可不传,后台自动查询",hidden = true)
    private Long accountId;
    /**
     * 赠送金额
     */
    @ApiModelProperty(name = "giveAmount", value = "赠送金额")
    private BigDecimal giveAmount;
    /**
     * 实付金额
     */
    @ApiModelProperty(name = "payAmount", value = "实付金额")
    private BigDecimal payAmount;
    /**
     * 充值金额
     */
    @ApiModelProperty(name = "totalAmount", value = "充值金额（充值金额=赠送金额+实付金额）",hidden = true)
    private BigDecimal totalAmount;
    /**
     * 订单关闭时间(未支付订单过期时间)
     */
    @ApiModelProperty(name = "closeTime", value = "订单关闭时间(未支付订单过期时间)",hidden = true)
    private Date closeTime;
    /**
     * 终端来源类型: 1: app端 2: PC端 3:微信端
     */
    @ApiModelProperty(name = "deviceType", value = "终端来源类型:1:app端2:PC端3:微信端")
    private String deviceType;
    /**
     *  支付方式
     */
    @ApiModelProperty(name = "rechargeType", value = "支付方式,现金支付CASH,银行转账BANK_TRANSFER,微信支付WE_PAY")
    private String rechargeType;
    /**
     * 收款方商家开户名称
     */
    @ApiModelProperty(value="开户名称")
    private String payAccountName;
    /**
     * 收款方商家开户名称
     */
    @ApiModelProperty(value="买家备注")
    private String buyerRemark;

    /**
     * 收款方商家开户账户
     */
    @ApiModelProperty(value="开户账户")
    private String payAccountNo;

    /**
     * 成功支付时间
     */
    @ApiModelProperty(value = "成功支付时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date paySuccessTime = new Date();

    @ApiModelProperty(name = "attachmentList", value = "附件")
    List<AttachmentReqDto> attachmentList;


    @ApiModelProperty(name = "openId", value = "使用微信支付时需要传openId")
    private String openId;

    @ApiModelProperty(name = "isRefer", value = "是否代替充值1是0否")
    private Integer isRefer = 0;

    public Integer getIsRefer() {
        return isRefer;
    }

    public void setIsRefer(Integer isRefer) {
        this.isRefer = isRefer;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Date getPaySuccessTime() {
        return paySuccessTime;
    }

    public void setPaySuccessTime(Date paySuccessTime) {
        this.paySuccessTime = paySuccessTime;
    }

    public String getBuyerRemark() {
        return buyerRemark;
    }

    public void setBuyerRemark(String buyerRemark) {
        this.buyerRemark = buyerRemark;
    }

    public List<AttachmentReqDto> getAttachmentList() {
        return attachmentList;
    }

    public void setAttachmentList(List<AttachmentReqDto> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public String getRechargeType() {
        return rechargeType;
    }

    public void setRechargeType(String rechargeType) {
        this.rechargeType = rechargeType;
    }

    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }

    public String getPayAccountNo() {
        return payAccountNo;
    }

    public void setPayAccountNo(String payAccountNo) {
        this.payAccountNo = payAccountNo;
    }


    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public BigDecimal getGiveAmount() {
        return giveAmount;
    }

    public void setGiveAmount(BigDecimal giveAmount) {
        this.giveAmount = giveAmount;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }



    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }
}