/**
 * @(#) AquiredBindCardReqDto.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author 风行
 * @since 0.5.0
 */
@ApiModel(value = "AquiredBindCardReqDto", description = "资金账户绑卡Dto")
public class AquiredBindCardReqDto extends BaseReqDto {

    /**
     * 资金账户ID
     */
    @ApiModelProperty(name = "accountId", value = "资金账户ID")
    @NotNull(message = "资金账户不能为空")
    private Long accountId;
    /**
     * 用户名
     */
    @ApiModelProperty(name = "userName", value = "用户名")
    @NotNull(message = "用户名不能为空")
    private String userName;
    /**
     * 手机号
     */
    @ApiModelProperty(name = "mobile", value = "手机号")
    @NotNull(message = "手机号不能为空")
    private String mobile;
    /**
     * 银行名称
     */
    @ApiModelProperty(name = "bankName", value = "银行名称")
    @NotNull(message = "银行名称不能为空")
    private String bankName;
    /**
     * 银行编码
     */
    @ApiModelProperty(name = "bankCode", value = "银行编码")
    @NotNull(message = "银行编码不能为空")
    private String bankCode;
    /**
     * 银行类型 B2c B2B
     */
    @ApiModelProperty(name = "bankType", value = "银行类型")
    @NotNull(message = "银行类型不能为空")
    private String bankType;
    /**
     * 银行卡号
     */
    @ApiModelProperty(name = "bankType", value = "银行类型")
    @NotNull(message = "银行卡号不能为空")
    private String bankAccount;
    /**
     * 证件类型
     */
    @ApiModelProperty(name = "idType", value = "证件类型")
    @NotNull(message = "证件类型不能为空")
    private String idType;
    /**
     * 证件编码
     */
    @ApiModelProperty(name = "idCode", value = "证件编码")
    @NotNull(message = "证件编码不能为空")
    private String idCode;

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getBankType() {
        return bankType;
    }

    public void setBankType(String bankType) {
        this.bankType = bankType;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getIdCode() {
        return idCode;
    }

    public void setIdCode(String idCode) {
        this.idCode = idCode;
    }
}
