/**
 * @(#) CreateAccReqDto.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author 风行
 * @since 0.5.0
 */
@ApiModel(value = "CreateAccReqDto", description = "创建资金账户Dto")
public class CreateAccReqDto extends BaseReqDto {

    @ApiModelProperty(name = "memberId", value = "会员ID")
    private Long memberId;


    /**
     * 账户类型
     */
    @ApiModelProperty(name = "accountType", value = "账户类型")
    @NotNull(message = "账户类型不能为空")
    private String accountType;

    /**
     * 用户类型
     */
    @ApiModelProperty(name = "userType", value = "用户类型")
    @NotNull(message = "用户类型不能为空")
    private String userType;

    /**
     * 用户名
     */
    @ApiModelProperty(name = "nickName", value = "用户名")
    private String nickName;
    /**
     * 手机号
     */
    @ApiModelProperty(name = "mobile", value = "手机号")
    @NotNull(message = "手机号不能为空")
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(name = "email", value = "邮箱")
    private String email;

    /**
     * 证件类型
     */
    @ApiModelProperty(name = "idType", value = "证件类型不能为空")
    @NotNull(message = "证件类型不能为空")
    private String idType;

    /**
     * 证件号码
     */
    @ApiModelProperty(name = "idCode", value = "证件号码")
    @NotNull(message = "证件号码不能为空")
    private String idCode;

    /**
     * 账户编号
     */
    @ApiModelProperty(name = "memberNo", value = "账户编号")
    private String memberNo;

    /**
     * 对应会员卡号, 或者团长编号
     */
    @ApiModelProperty(name = "outerId", value = "关联外部ID")
    private String outerId;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getIdCode() {
        return idCode;
    }

    public void setIdCode(String idCode) {
        this.idCode = idCode;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getOuterId() {
        return outerId;
    }

    public void setOuterId(String outerId) {
        this.outerId = outerId;
    }
}
