/*
 * @(#)AccountFlowSearchBody.java 1.0 2021年05月18日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 导出基础类
 */
@ApiModel(value = "ExportBaseReqDto", description = "导出基础类")
public class ExportBaseReqDto {

    /**
     * 账户Id
     */
    @NotNull(message = "导出类型 账号流水-ACCOUNT_FLOW;充值记录-RECHARGE_RECORD;充值单-RECHARGE_ORDER")
    @ApiModelProperty(name = "exportType", value = "导出类型")
    private String exportType;

    /**
     * 导出条件
     */
    @NotNull(message = "导出条件")
    @ApiModelProperty(name = "filter", value = "导出条件")
    private String filter;

    public String getExportType() {
        return exportType;
    }

    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}
