/*
 * @(#)ModifyAccPwdReqDto.java 1.0 2021年05月20日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>Title:ModifyAccPwdReqDto</p>
 * <p>Description: </p>
 *
 * @author 勉之
 * @date 2021/5/20 16:48
 * @since 0.1.0
 */

@ApiModel(value = "ModifyAccPwdReqDto", description = "修改资金账户密码Dto")
public class ModifyAccPwdReqDto extends BaseReqDto {

    @ApiModelProperty(name = "accountId", value = "账户id")
    private Long accountId;

    @ApiModelProperty(name = "oldPwd", value = "旧密码(重置密码传值)")
    private String oldPwd ;

    @ApiModelProperty(name = "newPwd", value = "新密码(初始设置传值)")
    private String newPwd ;

    /**
     * 账户类型：normal (ref:com.dtyunxi.yundt.cube.center.account.api.constants.Constants.AcccountType)
     */
    @ApiModelProperty(name = "accountType", value = "账户类型")
    private String accountType;

    /**
     * 用户类型：normal ( Constants.ACCOUNT_USER_TYPE_?)
     */
    @ApiModelProperty(name = "userType", value = "用户类型")
    private String userType;


    /**
     * 用户类型对应的userId
     */
    @ApiModelProperty(name = "userId", value = "用户类型对应的userId")
    private Long userId;

    /**
     * 证件类型
     */
    @ApiModelProperty(name = "idType", value = "证件类型")
    private String idType;

    /**
     * 证件号码
     */
    @ApiModelProperty(name = "idCode", value = "证件号码")
    private String idCode;

    /**
     * 收款方id
     */
    @ApiModelProperty(name = "payeeId", value = "收款方id")
    private Long payeeId;


    public String getOldPwd() {
        return oldPwd;
    }

    public void setOldPwd(String oldPwd) {
        this.oldPwd = oldPwd;
    }

    public String getNewPwd() {
        return newPwd;
    }

    public void setNewPwd(String newPwd) {
        this.newPwd = newPwd;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getIdCode() {
        return idCode;
    }

    public void setIdCode(String idCode) {
        this.idCode = idCode;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    @Override
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(Long payeeId) {
        this.payeeId = payeeId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

}
