/**
 * @(#) ModifyAccReqDto.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;


import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author 风行
 * @since 0.5.0
 */
@ApiModel(value = "ModifyAccReqDto", description = "修改资金账户Dto")
public class ModifyAccReqDto extends BaseReqDto {

    /**
     * id
     */
    @ApiModelProperty(name = "id", value = "id")
    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 用户名
     */
    @ApiModelProperty(name = "nickName", value = "用户名")
    private String nickName;
    /**
     * 手机号
     */
    @ApiModelProperty(name = "mobile", value = "手机号")
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(name = "email", value = "邮箱")
    private String email;

    /**
     * 证件类型
     */
    @ApiModelProperty(name = "idType", value = "证件类型不能为空")
    private String idType;

    /**
     * 证件号码
     */
    @ApiModelProperty(name = "idCode", value = "证件号码")
    private String idCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getIdCode() {
        return idCode;
    }

    public void setIdCode(String idCode) {
        this.idCode = idCode;
    }
}
