/*
 * @(#)PayMethodReqDto.java 1.0 2018/9/21
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @des 充值订单支付
 * @author lengqian
 * @data 2019/08/07
 */
@ApiModel(value = "PayRechargeOrderReqDto", description = "充值订单支付")
public class PayRechargeOrderReqDto extends RequestDto {
    /**
     * 用户终端ip
     */
    @ApiModelProperty(name = "userDeviceIp", value = "用户终端ip(微信h5支付时需要传)")
    private String userDeviceIp;

    /**
     * 场景信息
     */
    @ApiModelProperty(name = "sceneInfo", value = "场景信息(微信h5支付时需要传)")
    private String sceneInfo;
    /**
     * 交易流水号
     */
    @ApiModelProperty(name = "orderNo", value = "交易流水号")
    private String orderNo;
    /**
     * 支付方式
     */
    @ApiModelProperty(name = "payMethod", value = "支付方式")
    private String payMethod;
    /**
     * 支付页面回调地址
     */
    @ApiModelProperty(name = "backUrl", value = "支付页面回调地址")
    private String backUrl;
    /**
     * 使用微信支付时需要传openId
     */
    @ApiModelProperty(name = "openId", value = "使用微信支付时需要传openId")
    private String openId;
    /**
     * 支付中心分配商户ID
     */
    @ApiModelProperty(name = "storeId", value = "支付中心分配商户ID")
    private String storeId;
    /**
     * 支付中心分配应用ID
     */
    @ApiModelProperty(name = " appId", value = " 支付中心分配应用ID")
    private String appId;
    /**
     *  应用名称
     */
    @ApiModelProperty(name = "appName", value = "应用名称")
    private String appName;
    /**
     * 是否为自定义收款账户： 1 为 默认收款账户 2 自定义收款账户 不填为默认收款账户
     */
    @ApiModelProperty(name = "isDefined", value = "是否为自定义收款账户： 1-默认收款账户,2-自定义收款账户,(不填为默认收款账户)")
    private String isDefined;
    /**
     * 用户ID
     */
    @ApiModelProperty(name = "userId", value = "支付用户id")
    private String userId;
    /**
     * 拓展字段
     */
    @ApiModelProperty(name = "extension", value = "拓展字段")
    private String extension;

    public String getUserDeviceIp() {
        return userDeviceIp;
    }

    public void setUserDeviceIp(String userDeviceIp) {
        this.userDeviceIp = userDeviceIp;
    }

    public String getSceneInfo() {
        return sceneInfo;
    }

    public void setSceneInfo(String sceneInfo) {
        this.sceneInfo = sceneInfo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    public String getBackUrl() {
        return backUrl;
    }

    public void setBackUrl(String backUrl) {
        this.backUrl = backUrl;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getIsDefined() {
        return isDefined;
    }

    public void setIsDefined(String isDefined) {
        this.isDefined = isDefined;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
